/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.search;

import java.util.Collection;
import java.util.List;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestNodeModel;
import org.alfresco.rest.search.RestRequestQueryModel;
import org.alfresco.rest.search.SearchNodeModel;
import org.alfresco.rest.search.SearchRequest;
import org.alfresco.utility.RetryOperation;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public class NodeContentTest
extends RestTest {
    @TestRail(section={"rest-api", "search"}, executionType={ExecutionType.SANITY}, description="Check basic functionality of GET queries/sites")
    @Test(groups={"rest-api", "ratings", "core"})
    public void testNodeContent() throws Exception {
        UserModel adminUser = this.dataContent.getAdminUser();
        String fileName = "nodecontent.pdf";
        String term = "babekyrtso";
        FileModel fileModel = FileModel.getFileModelBasedOnTestDataFile((String)"nodecontent.pdf");
        this.restClient.authenticateUser(adminUser).configureRequestSpec().addMultiPart("filedata", fileModel.toFile());
        RestNodeModel node = this.restClient.authenticateUser(adminUser).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).createNode();
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        SearchRequest query = new SearchRequest();
        RestRequestQueryModel queryModel = new RestRequestQueryModel();
        queryModel.setLanguage("afts");
        queryModel.setQuery("babekyrtso");
        query.setQuery(queryModel);
        RetryOperation op = () -> {
            List entries = this.restClient.authenticateUser(adminUser).withSearchAPI().search(query).getEntries();
            Assert.assertFalse((boolean)CollectionUtils.isEmpty((Collection)entries), (String)"Search results should not be empty");
            boolean fileFound = entries.stream().map(SearchNodeModel::getModel).anyMatch(e -> "nodecontent.pdf".equals(e.getName()));
            Assert.assertTrue((boolean)fileFound, (String)"Search results should contain the file: nodecontent.pdf");
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
        };
        Utility.sleep((int)300, (int)100000, (RetryOperation)op);
        this.restClient.authenticateUser(adminUser).withCoreAPI().usingNode((RepoTestModel)ContentModel.my()).deleteNode(node);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }
}

