/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.sites.groups;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestSiteGroupModelsCollection;
import org.alfresco.rest.requests.Site;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetSiteGroupsTests
extends RestTest {
    private SiteModel publicSite;
    private SiteModel moderatedSite;
    private List<GroupModel> publicSiteGroups;
    private List<GroupModel> moderatedSiteGroups;
    private DataUser.ListUserWithRoles publicSiteUsers;
    private UserModel siteCreator;
    private UserModel regularUser;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.siteCreator = this.dataUser.createRandomTestUser();
        this.regularUser = this.dataUser.createRandomTestUser();
        this.publicSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createPublicRandomSite();
        this.moderatedSite = ((DataSite)this.dataSite.usingUser(this.siteCreator)).createModeratedRandomSite();
        this.publicSiteUsers = this.dataUser.addUsersWithRolesToSite(this.publicSite, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.publicSiteGroups = this.addGroupToSite(this.publicSite, UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor);
        this.moderatedSiteGroups = this.addGroupToSite(this.moderatedSite, UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor);
        RestSiteGroupModelsCollection siteGroups = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"properties=role,id"})).getSiteGroups();
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Verify Manager role gets site groups and gets status code OK (200)")
    public void getSiteGroupsWithManagerRole() throws Exception {
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingSite(this.publicSite).getSiteGroups().assertThat().entriesListCountIs(4)).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(0)))).and().entriesListContains("role", UserRole.SiteManager.name())).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(1)))).and().entriesListContains("role", UserRole.SiteCollaborator.name())).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(2)))).and().entriesListContains("role", UserRole.SiteConsumer.name())).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(3)))).and().entriesListContains("role", UserRole.SiteContributor.name());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator role gets site groups and gets status code OK (200)")
    public void getSiteGroupsWithCollaboratorRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingSite(this.publicSite).getSiteGroups().assertThat().entriesListCountIs(4)).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(1)))).and().entriesListContains("role", UserRole.SiteCollaborator.name());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor role gets site groups and gets status code OK (200)")
    public void getSiteGroupsWithContributorRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite(this.publicSite).getSiteGroups().assertThat().entriesListCountIs(4)).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(3)))).and().entriesListContains("role", UserRole.SiteContributor.name());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer role gets site groups and gets status code OK (200)")
    public void getSiteGroupsWithConsumerRole() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingSite(this.publicSite).getSiteGroups().assertThat().entriesListCountIs(4)).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(2)))).and().entriesListContains("role", UserRole.SiteConsumer.name());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user gets site groups and gets status code OK (200)")
    public void getSiteGroupsWithAdminUser() throws Exception {
        ((RestModels)((RestModels)this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(this.publicSite).getSiteGroups().assertThat().entriesListCountIs(4)).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(0)))).and().entriesListContains("role", UserRole.SiteManager.name());
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "sites", "sanity"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.SANITY}, description="Failed authentication get site groups call returns status code 401")
    public void unauthenticatedUserIsNotAuthorizedToRetrieveSiteGroups() throws Exception {
        UserModel userModel = this.dataUser.createRandomTestUser();
        userModel.setPassword("user wrong password");
        this.dataUser.addUserToSite(userModel, this.publicSite, UserRole.SiteManager);
        this.restClient.authenticateUser(userModel).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site members call returns status code 404 if siteId does not exist")
    public void checkStatusCodeForNonExistentSiteId() throws Exception {
        this.restClient.authenticateUser(this.publicSiteUsers.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingSite("NonExistentSiteId").getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY).assertLastError().containsSummary(String.format("Site %s does not exist", "NonExistentSiteId"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site groups call returns status code 400 for invalid maxItems")
    public void checkStatusCodeForInvalidMaxItems() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"maxItems=0"}).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
        this.restClient.withParams(new String[]{"maxItems=A"}).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify get site groups call returns status code 400 for invalid skipCount ")
    public void checkStatusCodeForInvalidSkipCount() throws Exception {
        this.restClient.authenticateUser(this.regularUser).withParams(new String[]{"skipCount=A"}).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
        this.restClient.withParams(new String[]{"skipCount=-1"}).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT);
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets public site groups and status code is 200")
    public void getPublicSiteGroups() throws Exception {
        RestSiteGroupModelsCollection siteGroups = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.publicSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)siteGroups.assertThat().entriesListCountIs(4)).assertThat().entriesListContains("id", this.getId(this.publicSiteGroups.get(0)))).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(1)))).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(2)))).and().entriesListContains("id", this.getId(this.publicSiteGroups.get(3)))).and().paginationField("count").is("4");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site groups and status code is 200")
    public void getModeratedSiteGroups() throws Exception {
        RestSiteGroupModelsCollection siteGroups = this.restClient.authenticateUser(this.regularUser).withCoreAPI().usingSite(this.moderatedSite).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)siteGroups.assertThat().entriesListCountIs(4)).assertThat().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(0)))).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(1)))).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(2)))).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(3)))).and().paginationField("count").is("4");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site groups with properties parameter applied and status code is 200")
    public void getModeratedSiteGroupsUsingPropertiesParameter() throws Exception {
        RestSiteGroupModelsCollection siteGroups = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"properties=role,id"})).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)((RestModels)siteGroups.assertThat().entriesListCountIs(4)).and().entriesListDoesNotContain("person")).and().entriesListContains("role", UserRole.SiteManager.toString())).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(0)))).and().entriesListContains("role", UserRole.SiteContributor.toString())).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(1)))).and().entriesListContains("role", UserRole.SiteCollaborator.toString())).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(2)))).and().entriesListContains("role", UserRole.SiteConsumer.toString())).and().entriesListContains("id", this.getId(this.moderatedSiteGroups.get(3)));
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site groups with skipCount parameter applied")
    public void getModeratedSiteGroupsUsingSkipCountParameter() throws Exception {
        RestSiteGroupModelsCollection siteGroups = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"skipCount=2"})).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        siteGroups.assertThat().paginationField("count").is("2");
        siteGroups.assertThat().paginationField("skipCount").is("2");
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site groups with high skipCount parameter applied")
    public void getModeratedSiteGroupsUsingHighSkipCountParameter() throws Exception {
        RestSiteGroupModelsCollection siteGroups = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"skipCount=100"})).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        siteGroups.assertThat().paginationField("count").is("0");
        siteGroups.assertThat().paginationField("skipCount").is("100");
        siteGroups.assertThat().entriesListIsEmpty();
    }

    @Test(groups={"rest-api", "sites", "regression"})
    @TestRail(section={"rest-api", "sites"}, executionType={ExecutionType.REGRESSION}, description="Verify if any user gets moderated site groups with maxItems parameter applied and check all pagination fields")
    public void getModeratedSiteGroupsUsingMaxItemsParameter() throws Exception {
        RestSiteGroupModelsCollection siteGroups = ((Site)this.restClient.authenticateUser(this.siteCreator).withCoreAPI().usingSite(this.moderatedSite).usingParams(new String[]{"maxItems=1"})).getSiteGroups();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        siteGroups.assertThat().paginationField("count").is("1");
        siteGroups.assertThat().paginationField("hasMoreItems").is("true");
        siteGroups.assertThat().paginationField("maxItems").is("1");
        siteGroups.assertThat().paginationField("totalItems").is("4");
        siteGroups.assertThat().entriesListCountIs(1);
    }

    List<GroupModel> addGroupToSite(SiteModel siteModel, UserRole ... roles) {
        ArrayList<GroupModel> groups = new ArrayList<GroupModel>();
        for (UserRole role : roles) {
            GroupModel group = this.dataGroup.createRandomGroup();
            this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingSite(siteModel).addSiteGroup(this.getId(group), role);
            groups.add(group);
        }
        return groups;
    }

    String getId(GroupModel group) {
        return "GROUP_" + group.getGroupIdentifier();
    }
}

