/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.processes.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestProcessModel;
import org.alfresco.rest.model.RestProcessVariableCollection;
import org.alfresco.rest.model.RestProcessVariableModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetProcessVariablesFullTests
extends RestTest {
    private UserModel userWhoStartsProcess;
    private UserModel assignee;
    private UserModel admin;
    private RestProcessModel processModel;
    private RestProcessVariableCollection variables;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.admin = this.dataUser.getAdminUser();
        this.userWhoStartsProcess = this.dataUser.createRandomTestUser();
        this.assignee = this.dataUser.createRandomTestUser();
        this.processModel = this.restClient.authenticateUser(this.userWhoStartsProcess).withWorkflowAPI().addProcess("activitiAdhoc", this.assignee, false, CMISUtil.Priority.Normal);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables call using admin user. Admin can see the process even if he isn't involved in it.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesUsingAdmin() throws Exception {
        this.variables = this.restClient.authenticateUser(this.admin).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variables.assertThat().entriesListIsNotEmpty();
        ((RestProcessVariableModel)((RestProcessVariableModel)this.variables.getProcessVariableByName("initiator").assertThat().field("name").is((Object)"initiator")).assertThat().field("type").is((Object)"d:noderef")).assertThat().field("value").is((Object)this.userWhoStartsProcess.getUsername());
        ((RestProcessVariableModel)((RestProcessVariableModel)this.variables.getProcessVariableByName("bpm_assignee").assertThat().field("name").is((Object)"bpm_assignee")).assertThat().field("type").is((Object)"cm:person")).assertThat().field("value").is((Object)this.assignee.getUsername());
        ((RestProcessVariableModel)((RestProcessVariableModel)this.variables.getProcessVariableByName("bpm_sendEMailNotifications").assertThat().field("name").is((Object)"bpm_sendEMailNotifications")).assertThat().field("type").is((Object)"d:boolean")).assertThat().field("value").is((Object)false);
        ((RestProcessVariableModel)((RestProcessVariableModel)this.variables.getProcessVariableByName("bpm_priority").assertThat().field("name").is((Object)"bpm_priority")).assertThat().field("type").is((Object)"d:int")).assertThat().field("value").is((Object)CMISUtil.Priority.Normal.getLevel());
    }

    @Bug(id="MNT-17438")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with valid skip count parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithValidSkipCount() throws Exception {
        this.variables = this.restClient.authenticateUser(this.admin).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variables.assertThat().entriesListIsNotEmpty();
        RestProcessVariableCollection variablesSkipped = this.restClient.authenticateUser(this.admin).withParams(new String[]{"skipCount=2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)variablesSkipped.assertThat().entriesListDoesNotContain("name", ((RestProcessVariableModel)this.variables.getEntries().get(0)).onModel().getName())).assertThat().entriesListDoesNotContain("name", ((RestProcessVariableModel)this.variables.getEntries().get(1)).onModel().getName())).assertThat().entriesListCountIs(this.variables.getEntries().size() - 2)).assertThat().paginationField("skipCount").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with negative skip count parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithNegativeSkipCount() throws Exception {
        this.restClient.authenticateUser(this.admin).withParams(new String[]{"skipCount=-2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with not numeric skip count parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithNonNumericSkipCount() throws Exception {
        this.restClient.authenticateUser(this.admin).withParams(new String[]{"skipCount=A"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_SKIPCOUNT, "A"));
    }

    @Bug(id="MNT-17438")
    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with valid maxItems parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithValidMaxItems() throws Exception {
        this.variables = this.restClient.authenticateUser(this.admin).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variables.assertThat().entriesListIsNotEmpty();
        RestProcessVariableCollection variablesSkipped = this.restClient.authenticateUser(this.admin).withParams(new String[]{"maxItems=2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)((RestModels)variablesSkipped.assertThat().entriesListContains("name", ((RestProcessVariableModel)this.variables.getEntries().get(0)).onModel().getName())).assertThat().entriesListContains("name", ((RestProcessVariableModel)this.variables.getEntries().get(1)).onModel().getName())).assertThat().entriesListCountIs(2)).assertThat().paginationField("maxItems").is("2");
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with negative maxItems parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithNegativeMaxItems() throws Exception {
        this.restClient.authenticateUser(this.admin).withParams(new String[]{"maxItems=-2"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE).statusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with not numeric maxItems parameter applied.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithNonNumericMaxItems() throws Exception {
        this.restClient.authenticateUser(this.admin).withParams(new String[]{"maxItems=A"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsSummary(String.format(RestErrorModel.INVALID_MAXITEMS, "A"));
    }

    @TestRail(section={"rest-api", "workflow", "processes"}, executionType={ExecutionType.REGRESSION}, description="Verify get all process variables with properties parameter.")
    @Test(groups={"rest-api", "workflow", "processes", "regression"})
    public void getProcessVariablesWithPropertiesParameter() throws Exception {
        this.variables = this.restClient.authenticateUser(this.admin).withParams(new String[]{"properties=name"}).withWorkflowAPI().usingProcess((ProcessModel)this.processModel).getProcessVariables();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.variables.assertThat().entriesListIsNotEmpty();
        ((RestProcessVariableModel)((RestProcessVariableModel)((RestProcessVariableModel)this.variables.getProcessVariableByName("initiator").assertThat().field("name").is((Object)"initiator")).assertThat().field("type").isNull()).assertThat().field("value").isNull()).assertThat().fieldsCount().is((Object)1);
    }
}

