/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import java.util.List;
import org.alfresco.rest.core.JsonBodyGenerator;
import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestRuleModel;
import org.alfresco.rest.model.RestRuleModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class FolderRules
extends ModelRequest<FolderRules> {
    private static final String BASE_PATH = "nodes/{nodeId}/rule-sets/{ruleSetId}/rules";
    private static final String RULE_ID_PATH = "/{ruleId}";
    private String nodeId;
    private String ruleSetId;

    public FolderRules withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public FolderRules withRuleSetId(String ruleSetId) {
        this.ruleSetId = ruleSetId;
        return this;
    }

    public FolderRules(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestRuleModelsCollection getListOfRules() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, BASE_PATH, this.nodeId, this.ruleSetId);
        return this.restWrapper.processModels(RestRuleModelsCollection.class, request);
    }

    public RestRuleModel getSingleRule(String ruleId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "nodes/{nodeId}/rule-sets/{ruleSetId}/rules/{ruleId}", this.nodeId, this.ruleSetId, ruleId);
        return this.restWrapper.processModel(RestRuleModel.class, request);
    }

    public RestRuleModelsCollection createListOfRules(List<RestRuleModel> ruleModels) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, JsonBodyGenerator.arrayToJson(ruleModels), BASE_PATH, this.nodeId, this.ruleSetId);
        return this.restWrapper.processModels(RestRuleModelsCollection.class, request);
    }

    public RestRuleModel createSingleRule(RestRuleModel ruleModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, ruleModel.toJson(), BASE_PATH, this.nodeId, this.ruleSetId);
        return this.restWrapper.processModel(RestRuleModel.class, request);
    }

    public RestRuleModel updateRule(String ruleId, RestRuleModel ruleModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, ruleModel.toJson(), "nodes/{nodeId}/rule-sets/{ruleSetId}/rules/{ruleId}", this.nodeId, this.ruleSetId, ruleId);
        return this.restWrapper.processModel(RestRuleModel.class, request);
    }

    public void deleteRule(String ruleId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "nodes/{nodeId}/rule-sets/{ruleSetId}/rules/{ruleId}", this.nodeId, this.ruleSetId, ruleId);
        this.restWrapper.processEmptyModel(request);
    }
}

