/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.favorites;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteFavoriteTests
extends RestTest {
    private UserModel adminUserModel;
    private SiteModel siteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private FileModel fileModel;
    private FolderModel folderModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUserModel = this.dataUser.getAdminUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.adminUserModel)).createPublicRandomSite();
        this.siteModel.setGuid(this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.siteModel).getSite().getGuid());
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.adminUserModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.folderModel = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.adminUserModel).createFolder();
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify Manager user deletes site from favorites with Rest API and status code is 204")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void managerIsAbleToDeleteFavorites() throws Exception {
        UserModel siteManager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel.getGuid())).and().entriesListDoesNotContain("id", this.siteModel.getId())).and().entriesListDoesNotContain("description", this.siteModel.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "favorites", "sanity"})
    public void userIsNotAbleToDeleteFavoritesIfAuthenticationFails() throws Exception {
        UserModel siteManager = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user deletes site from favorites with Rest API and status code is 204")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsAbleToDeleteFavorites() throws Exception {
        UserModel siteCollaborator = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(siteCollaborator).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel.getGuid())).and().entriesListDoesNotContain("id", this.siteModel.getId())).and().entriesListDoesNotContain("description", this.siteModel.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user deletes site from favorites with Rest API and status code is 204")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsAbleToDeleteFavorites() throws Exception {
        UserModel siteContributor = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(siteContributor).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel.getGuid())).and().entriesListDoesNotContain("id", this.siteModel.getId())).and().entriesListDoesNotContain("description", this.siteModel.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user delets site from favorites with Rest API and status code is 204")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsAbleToDeleteFavorites() throws Exception {
        UserModel siteConsumer = this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        this.restClient.authenticateUser(siteConsumer).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        ((RestModels)((RestModels)((RestModels)((RestModels)this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel.getGuid())).and().entriesListDoesNotContain("id", this.siteModel.getId())).and().entriesListDoesNotContain("description", this.siteModel.getDescription())).and().entriesListDoesNotContain("visibility", this.siteModel.getVisibility().toString())).and().entriesListDoesNotContain("title", this.siteModel.getTitle());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user deletes site from favorites with Rest API and status code is 204")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToDeleteFavorites() throws Exception {
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.siteModel.getGuid());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin deletes files from favorites with Rest API and status code is (204)")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToDeleteFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.fileModel.getNodeRefWithoutVersion());
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin deletes folder from favorites with Rest API and status code is (204)")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsAbleToDeleteFavoriteFolder() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().deleteFolderFromFavorites(this.folderModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.fileModel.getNodeRefWithoutVersion());
    }

    @Test(groups={"rest-api", "favorites", "regression"})
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user removes a site from favorites using '-me-' in place of personId with Rest API and response is successful (204)")
    public void deleteFavoriteSiteWithSuccessUsingMeAsPersonId() throws Exception {
        this.siteModel.setGuid(this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingSite(this.siteModel).getSite().getGuid());
        this.restClient.withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingMe().deleteSiteFromFavorites(this.siteModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to delete favorites of admin user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToDeleteFavoritesOfAdminUser() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsNotAbleToDeleteFavoritesOfASiteMember() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void consumerIsNotAbleToDeleteFavoritesOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify consumer user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void collaboratorIsNotAbleToDeleteFavoriteOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void contributorIsNotAbleToDeleteFavoriteOfAnotherUser() throws Exception {
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor)).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @Bug(id="ACE-5588")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsNotAbleToDeleteFavoriteOfAnotherUser() throws Exception {
        UserModel user = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(user).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if PersonID is incorrect - favorite file.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteIfPersonIdNotExists() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        this.restClient.withCoreAPI().usingUser(new UserModel("inexistent", "inexistent")).deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "inexistent"));
    }

    @Bug(id="ACE-2413")
    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if PersonID is empty - favorite file.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteIfPersonIdIsEmpty() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        this.restClient.withCoreAPI().usingUser(new UserModel("", "")).deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.BAD_REQUEST);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if FavoriteID is incorrect - favorite file.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteFileIfFavoriteIdIsIncorrect() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        this.fileModel.setNodeRef("wrongFavoriteId");
        this.restClient.withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "wrongFavoriteId"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if FavoriteID is incorrect - favorite file.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteFileIfFavoriteIdNotExists() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        FileModel inexistentDocument = new FileModel();
        inexistentDocument.setNodeRef("inexistent");
        this.restClient.withCoreAPI().usingAuthUser().deleteFileFromFavorites(inexistentDocument).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "inexistent"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if FavoriteID is incorrect - favorite site.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteSiteIfFavoriteIdNotExists() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.siteModel.setGuid("wrongFavoriteId");
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "wrongFavoriteId"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify that status code is 404 if FavoriteID is incorrect - favorite folder.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void deleteFavoriteFolderIfFavoriteIdNotExists() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingUser(this.adminUserModel).addSiteToFavorites(this.siteModel);
        this.restClient.withCoreAPI().usingAuthUser().addFolderToFavorites(this.folderModel);
        this.folderModel.setNodeRef("wrongFavoriteId");
        this.restClient.withCoreAPI().usingAuthUser().deleteFolderFromFavorites(this.folderModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "wrongFavoriteId"));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify admin is not able to deletes files from favorites that were already deleted with Rest API and status code is (404)")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminIsNotAbleToDeleteADeletedFavoriteFile() throws Exception {
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().addFileToFavorites(this.fileModel);
        this.restClient.assertStatusCodeIs(HttpStatus.CREATED);
        this.restClient.withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingAuthUser().getFavorites().assertThat().entriesListDoesNotContain("targetGuid", this.fileModel.getNodeRefWithoutVersion());
        this.restClient.withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.fileModel.getNodeRef()));
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify user can't delete favorites using an invalid network ID.")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void userIsNotAbleToDeleteFavoriteSiteWithInvalidNetworkID() throws Exception {
        UserModel networkUserModel = this.dataUser.createRandomTestUser();
        this.restClient.authenticateUser(networkUserModel).withCoreAPI().usingAuthUser().addSiteToFavorites(this.siteModel);
        networkUserModel.setDomain("invalidNetwork");
        this.restClient.withCoreAPI().usingAuthUser().deleteSiteFromFavorites(this.siteModel).assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "favorites"}, executionType={ExecutionType.REGRESSION}, description="Verify contributor user doesn't have permission to delete favorites of another user with Rest API and status code is 404")
    @Test(groups={"rest-api", "favorites", "regression"})
    public void adminDeletesFavoriteForNotFavouriteFile() throws Exception {
        this.fileModel = ((DataContent)this.dataContent.usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.adminUserModel).withCoreAPI().usingAuthUser().deleteFileFromFavorites(this.fileModel).assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.RELATIONSHIP_NOT_FOUND, this.adminUserModel.getUsername(), this.fileModel.getNodeRef())).containsErrorKey(RestErrorModel.RELATIONSHIP_NOT_FOUND_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }
}

