/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.activities;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestActivityModelsCollection;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleActivitiesSanityTests
extends RestTest {
    UserModel userModel;
    UserModel unauthenticatedUser;
    SiteModel siteModel;
    private DataUser.ListUserWithRoles usersWithRoles;
    private RestActivityModelsCollection restActivityModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.usersWithRoles = this.dataUser.addUsersWithRolesToSite(this.siteModel, new UserRole[]{UserRole.SiteManager, UserRole.SiteCollaborator, UserRole.SiteConsumer, UserRole.SiteContributor});
        this.unauthenticatedUser = ((DataUser)this.dataUser.usingAdmin()).createRandomTestUser();
        this.unauthenticatedUser.setPassword("newpassword");
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify manager user gets its activities with Rest API and response is successful")
    public void managerUserShouldGetPeopleActivitiesList() throws Exception {
        UserModel managerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        ((DataContent)this.dataContent.usingUser(managerUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restActivityModelsCollection = this.restClient.authenticateUser(managerUser).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify collaborator user gets its activities with Rest API and response is successful")
    public void collaboratorUserShouldGetPeopleActivitiesList() throws Exception {
        UserModel collaboratorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator);
        ((DataContent)this.dataContent.usingUser(collaboratorUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restActivityModelsCollection = this.restClient.authenticateUser(collaboratorUser).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify contributor user gets its activities with Rest API and response is successful")
    public void contributorUserShouldGetPeopleActivitiesList() throws Exception {
        UserModel contributorUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        ((DataContent)this.dataContent.usingUser(contributorUser).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restActivityModelsCollection = this.restClient.authenticateUser(contributorUser).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify consumer user gets its activities with Rest API and response is successful")
    public void consumerUserShouldGetPeopleActivitiesList() throws Exception {
        UserModel consumerUser = this.usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer);
        this.restActivityModelsCollection = this.restClient.authenticateUser(consumerUser).withCoreAPI().usingAuthUser().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify admin user gets another user activities with Rest API and response is successful")
    public void adminUserShouldGetPeopleActivitiesList() throws Exception {
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.dataUser.getAdminUser()).withCoreAPI().usingUser(this.userModel).getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListIsNotEmpty()).and().entriesListContains("siteId", this.siteModel.getId())).and().paginationExist();
    }

    @Test(groups={"rest-api", "people", "activities", "sanity"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.SANITY}, description="Verify unauthenticated user is NOT Authorized to gets another user activities with Rest API")
    public void unauthenticatedUserShouldNotGetPeopleActivitiesList() throws Exception {
        this.restClient.authenticateUser(this.unauthenticatedUser).withCoreAPI().usingUser(this.userModel).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }
}

