/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.tags.nodes;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestTagModel;
import org.alfresco.rest.tags.TagsDataPrep;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.http.HttpStatus;
import org.testng.annotations.Ignore;
import org.testng.annotations.Test;

@Test(groups={"require-solr"})
public class DeleteTagTests
extends TagsDataPrep {
    private RestTagModel tag;
    private FileModel contributorDoc;

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin user deletes tags with Rest API and status code is 204")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminIsAbleToDeleteTags() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).getNodeTags().assertThat().entriesListDoesNotContain("tag", this.tag.getTag());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify Manager user deletes tags created by admin user with Rest API and status code is 204")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void managerIsAbleToDeleteTags() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user deletes tags created by admin user with Rest API and status code is 204")
    @Test(groups={"rest-api", "tags", "regression"})
    public void collaboratorIsAbleToDeleteTags() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user can't delete tags created by admin user with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsNotAbleToDeleteTagsForAnotherUserContent() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteContributor));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Contributor user deletes tags created by him with Rest API and status code is 204")
    @Test(groups={"rest-api", "tags", "regression"})
    public void contributorIsAbleToDeleteTagsForHisContent() {
        userModel = usersWithRoles.getOneUserWithRole(UserRole.SiteContributor);
        this.restClient.authenticateUser(userModel);
        this.contributorDoc = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(userModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)this.contributorDoc).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Consumer user can't delete tags created by admin user with Rest API and status code is 403")
    @Test(groups={"rest-api", "tags", "regression"})
    public void consumerIsNotAbleToDeleteTags() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteConsumer));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.SANITY}, description="Verify user gets status code 401 if authentication call fails")
    @Test(groups={"rest-api", "tags", "sanity"})
    public void userIsNotAbleToDeleteTagIfAuthenticationFails() {
        this.restClient.authenticateUser(adminUserModel);
        this.tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        UserModel siteManager = usersWithRoles.getOneUserWithRole(UserRole.SiteManager);
        String managerPassword = siteManager.getPassword();
        siteManager.setPassword("wrongPassword");
        this.restClient.authenticateUser(siteManager);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
        siteManager.setPassword(managerPassword);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if user has no permission to remove tag returned status code is 403. Check default error model schema")
    @Test(groups={"rest-api", "tags", "regression"})
    public void deleteTagWithUserWithoutPermissionCheckDefaultErrorModelSchema() {
        this.restClient.authenticateUser(adminUserModel);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(this.dataUser.createRandomTestUser());
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(tag);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED).containsErrorKey(RestErrorModel.PERMISSION_DENIED_ERRORKEY).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if node does not exist returned status code is 404")
    @Test(groups={"rest-api", "tags", "regression"})
    public void deleteTagForANonexistentNode() {
        this.restClient.authenticateUser(adminUserModel);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        FileModel document = ((DataContent)this.dataContent.usingSite(siteModel)).usingUser(adminUserModel).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        String nodeRef = RandomStringUtils.randomAlphanumeric((int)10);
        document.setNodeRef(nodeRef);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, nodeRef));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if tag does not exist returned status code is 404")
    @Test(groups={"rest-api", "tags", "regression"})
    public void deleteTagThatDoesNotExist() {
        this.restClient.authenticateUser(adminUserModel);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        tag.setId("abc");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "abc"));
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that if tag id is empty returned status code is 405")
    @Test(groups={"rest-api", "tags", "regression"})
    public void deleteTagWithEmptyId() {
        this.restClient.authenticateUser(adminUserModel);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        tag.setId("");
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(tag);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify that folder tag can be deleted")
    @Test(groups={"rest-api", "tags", "regression"})
    public void deleteFolderTag() {
        FolderModel folderModel = ((DataContent)this.dataContent.usingUser(adminUserModel).usingSite(siteModel)).createFolder();
        this.restClient.authenticateUser(adminUserModel);
        RestTagModel tag = this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).deleteTag(tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)folderModel).getNodeTags().assertThat().entriesListDoesNotContain("tag", tag.getTag());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can't delete deleted tag.")
    @Test(groups={"rest-api", "tags", "regression"})
    @Bug(id="ACE-5455")
    @Ignore
    public void managerCannotDeleteDeletedTag() {
        this.tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomData.getRandomName((String)"tag"));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Collaborator user can delete long tag.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void userCollaboratorCanDeleteLongTag() {
        String longTag = RandomStringUtils.randomAlphanumeric((int)800);
        this.tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(longTag);
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can delete short tag.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void managerCanDeleteShortTag() {
        String shortTag = RandomStringUtils.randomAlphanumeric((int)10);
        this.tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(shortTag);
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Admin can delete tag then add it again.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void adminRemovesTagAndAddsItAgain() {
        String tagValue = RandomStringUtils.randomAlphanumeric((int)10);
        this.tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(tagValue);
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.tag = this.restClient.authenticateUser(adminUserModel).withCoreAPI().usingResource((RepoTestModel)document).addTag(tagValue);
        RestTagModel returnedTag = this.restClient.withCoreAPI().getTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        returnedTag.assertThat().field("tag").is((Object)tagValue.toLowerCase());
    }

    @TestRail(section={"rest-api", "tags"}, executionType={ExecutionType.REGRESSION}, description="Verify Manager user can delete tag added by another user.")
    @Test(groups={"rest-api", "tags", "regression"})
    public void managerCanDeleteTagAddedByAnotherUser() {
        this.tag = this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteCollaborator)).withCoreAPI().usingResource((RepoTestModel)document).addTag(RandomStringUtils.randomAlphanumeric((int)10));
        this.restClient.authenticateUser(usersWithRoles.getOneUserWithRole(UserRole.SiteManager)).withCoreAPI().usingResource((RepoTestModel)document).deleteTag(this.tag);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
    }
}

