/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.people.activities;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.core.RestModels;
import org.alfresco.rest.model.RestActivityModelsCollection;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.requests.People;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class GetPeopleActivitiesCoreTests
extends RestTest {
    UserModel userModel;
    UserModel adminUser;
    UserModel managerUser;
    SiteModel siteModel1;
    SiteModel siteModel2;
    FileModel fileInSite1;
    FileModel fileInSite2;
    FolderModel folderInSite2;
    private RestActivityModelsCollection restActivityModelsCollection;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.siteModel1 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileInSite1 = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel1)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.siteModel2 = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.folderInSite2 = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel2)).createFolder();
        this.fileInSite2 = ((DataContent)this.dataContent.usingAdmin().usingSite(this.siteModel2)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.managerUser = this.dataUser.createRandomTestUser();
        ((DataUser)this.dataUser.usingUser(this.userModel)).addUserToSite(this.managerUser, this.siteModel2, UserRole.SiteManager);
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().getPersonActivitiesUntilEntriesCountIs(6);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("6");
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user cannot get activities for inexistent user with Rest API and response is 404")
    public void userCannotGetPeopleActivitiesForInexistentPersonId() throws Exception {
        UserModel inexistentUserName = new UserModel("inexistent", "password");
        this.restActivityModelsCollection = this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(inexistentUserName).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, inexistentUserName.getUsername())).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets its activities for inexistent siteId with Rest API and response is 404")
    public void userGetItsPeopleActivitiesForInexistentSite() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).usingParams(new String[]{String.format("siteId=inexistent", new Object[0])})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "inexistent")).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER).stackTraceIs(RestErrorModel.STACKTRACE);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities with invald skipCount parameter with Rest API and response is 400")
    public void userGetPeopleActivitiesUsingInvalidSkipCountParameter() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{"skipCount=-1"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).containsSummary(RestErrorModel.NEGATIVE_VALUES_SKIPCOUNT).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities with invalid maxItems parameter with Rest API and response is 400")
    public void userGetPeopleActivitiesUsingInvalidMaxItemsParameter() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingMe().usingParams(new String[]{"maxItems=0"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).containsSummary(RestErrorModel.ONLY_POSITIVE_VALUES_MAXITEMS).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities using invalid value for parameter 'who'with Rest API and response is 400")
    public void userGetsPeopleActivitiesUsingInvalidValueForWhoParameter() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).usingParams(new String[]{"who=mee"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.BAD_REQUEST).assertLastError().containsErrorKey(RestErrorModel.INVALID_PARAMETER_WHO).containsSummary(RestErrorModel.INVALID_PARAMETER_WHO).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @Test(groups={"rest-api", "people", "activities", "regression"})
    @TestRail(section={"rest-api", "people", "activities"}, executionType={ExecutionType.REGRESSION}, description="Verify user gets activities successfully using parameter 'who' with 'others' value with Rest API")
    public void userGetsPeopleActivitiesUsingOthersForWhoParameter() throws Exception {
        this.restActivityModelsCollection = ((People)this.restClient.authenticateUser(this.userModel).withCoreAPI().usingUser(this.userModel).usingParams(new String[]{"who=others"})).getPersonActivities();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restActivityModelsCollection.assertThat().paginationField("count").is("3");
        ((RestModels)((RestModels)this.restActivityModelsCollection.assertThat().entriesListDoesNotContain("postPersonId", this.userModel.getUsername().toLowerCase())).and().entriesListContains("postPersonId", this.adminUser.getUsername().toLowerCase())).and().entriesListContains("postPersonId", this.managerUser.getUsername().toLowerCase());
    }
}

