/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.workflow.tasks.variables;

import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestErrorModel;
import org.alfresco.rest.model.RestVariableModel;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.data.DataWorkflow;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeleteTaskVariableTests
extends RestTest {
    private UserModel userModel;
    private UserModel assigneeUser;
    private UserModel adminUser;
    private SiteModel siteModel;
    private FileModel fileModel;
    private TaskModel taskModel;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws Exception {
        this.adminUser = this.dataUser.getAdminUser();
        this.userModel = this.dataUser.createRandomTestUser();
        this.assigneeUser = this.dataUser.createRandomTestUser();
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.userModel)).createPublicRandomSite();
        this.fileModel = ((DataContent)this.dataContent.usingUser(this.userModel).usingSite(this.siteModel)).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.taskModel = ((DataWorkflow)((DataWorkflow)((DataWorkflow)this.dataWorkflow.usingUser(this.userModel)).usingSite(this.siteModel)).usingResource((ContentModel)this.fileModel)).createNewTaskAndAssignTo(this.assigneeUser);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Delete existing task variable")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void deleteTaskVariable() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Try to delete existing task variable using invalid task id")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void tryToDeleteTaskVariableUsingInvalidTaskId() throws Exception {
        this.restClient.authenticateUser(this.adminUser);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(variableModel);
        this.taskModel.setId("incorrectTaskId");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.SANITY}, description="Delete task variable with any user")
    @Test(groups={"rest-api", "workflow", "tasks", "sanity"})
    public void deleteTaskVariableByAnyUser() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable with invalid type")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskVariableInvalidType() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        variableModel.setType("invalid-type");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Create, update, delete task variable with any user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void createUpdateDeleteTaskVariableByAnyUser() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        variableModel.setName("new-variable");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).updateTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable by non assigned user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskVariableByNonAssignedUser() throws Exception {
        UserModel nonAssigned = this.dataUser.createRandomTestUser();
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.authenticateUser(nonAssigned).withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.FORBIDDEN).assertLastError().containsSummary(RestErrorModel.PERMISSION_WAS_DENIED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable by inexistent user")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskVariableByInexistentUser() throws Exception {
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.authenticateUser(this.userModel).withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.authenticateUser(UserModel.getRandomUserModel()).withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable twice")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskVariableTwice() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, variableModel.getName())).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable with empty variable name")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskEmptyVariableName() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        variableModel.setName("");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.METHOD_NOT_ALLOWED).assertLastError().containsErrorKey(RestErrorModel.DELETE_EMPTY_ARGUMENT).containsSummary(RestErrorModel.DELETE_EMPTY_ARGUMENT).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable with empty variable scope")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskEmptyVariableScope() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        variableModel.setScope("");
        variableModel.setType("");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NO_CONTENT);
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).getTaskVariables().assertThat().entriesListDoesNotContain("name", variableModel.getName());
    }

    @TestRail(section={"rest-api", "workflow", "tasks"}, executionType={ExecutionType.REGRESSION}, description="Delete task variable with invalid variable name")
    @Test(groups={"rest-api", "workflow", "tasks", "regression"})
    public void deleteTaskInvalidVariableName() throws Exception {
        this.restClient.authenticateUser(this.userModel);
        RestVariableModel variableModel = RestVariableModel.getRandomTaskVariableModel((String)"local", (String)"d:text");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).addTaskVariable(variableModel);
        variableModel.setName("invalid-name");
        this.restClient.withWorkflowAPI().usingTask(this.taskModel).deleteTaskVariable(variableModel);
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND).assertLastError().containsErrorKey(RestErrorModel.ENTITY_NOT_FOUND_ERRORKEY).containsSummary(String.format(RestErrorModel.ENTITY_NOT_FOUND, "invalid-name")).stackTraceIs(RestErrorModel.STACKTRACE).descriptionURLIs(RestErrorModel.RESTAPIEXPLORER);
    }
}

