/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core.assertion;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import io.restassured.path.json.JsonPath;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.TestModel;
import org.testng.Assert;

public class ModelAssertion<T> {
    private final Object model;

    protected static void checkFieldIsPresent(Object fieldNameToBeRetuned, Object fieldValueToBeRetuned) {
        if (fieldValueToBeRetuned == null) {
            Assert.fail((String)String.format("Field {%s} was not found in returned response.", fieldNameToBeRetuned));
        }
    }

    public ModelAssertion(Object model) {
        this.model = model;
    }

    public AssertionVerbs field(String fieldName) {
        ObjectMapper mapper = new ObjectMapper();
        String jsonInString = null;
        try {
            jsonInString = mapper.writeValueAsString(this.model);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
        Object fieldValue = JsonPath.with((String)jsonInString).get(fieldName);
        return new AssertionVerbs(this, this.model, fieldValue, fieldName);
    }

    public AssertionItemVerbs fieldsCount() {
        int actualSize = 0;
        List<Field> allFields = this.getAllDeclaredFields(new LinkedList<Field>(), this.model.getClass());
        for (Field field : allFields) {
            field.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = field.get(this.model);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Unable to load model using reflection.", e);
            }
            if (fieldValue == null) continue;
            ++actualSize;
        }
        return new AssertionItemVerbs(this, this.model, actualSize);
    }

    public T isEqualTo(T expected, String ... ignoreFields) {
        Object modelCopy = this.createCopyIgnoringFields(this.model, ignoreFields);
        T expectedCopy = this.createCopyIgnoringFields(expected, ignoreFields);
        Assert.assertEquals((Object)modelCopy, expectedCopy, (String)String.format("Compared objects of type: %s are not equal!", this.model.getClass()));
        return (T)this.model;
    }

    private List<Field> getAllDeclaredFields(List<Field> fields, Class<?> classz) {
        if (classz.isAssignableFrom(TestModel.class)) {
            return fields;
        }
        fields.addAll(Arrays.asList(classz.getDeclaredFields()));
        if (classz.getSuperclass() != null) {
            fields = this.getAllDeclaredFields(fields, classz.getSuperclass());
        }
        return fields;
    }

    private T createCopyIgnoringFields(T model, String ... ignoreFields) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new SerializableTypeAdapterFactory(this));
        Gson gson = gsonBuilder.create();
        JsonObject jsonObject = (JsonObject)gson.fromJson(gson.toJson(model), JsonObject.class);
        for (String ignoreField : ignoreFields) {
            jsonObject.remove(ignoreField);
        }
        return (T)gson.fromJson(gson.toJson((JsonElement)jsonObject), model.getClass());
    }

    public class AssertionVerbs {
        private String fieldName;
        private Object model;
        private Object fieldValue;

        public AssertionVerbs(ModelAssertion this$0, Object model, Object fieldValue, String fieldName) {
            this.model = model;
            this.fieldValue = fieldValue;
            this.fieldName = fieldName;
        }

        private String errorMessage(String info) {
            return String.format("The value of field [%s -> from %s] %s", this.fieldName, this.model.getClass().getCanonicalName(), info);
        }

        public T isNot(Object expected) {
            ModelAssertion.checkFieldIsPresent(this.fieldName, this.fieldValue);
            Assert.assertNotEquals((Object)this.fieldValue, (Object)expected, (String)this.errorMessage("is correct,"));
            return this.model;
        }

        public boolean equals(Object o) {
            throw new UnsupportedOperationException("You probably want to use is() rather than equals()");
        }

        public T is(Object expected) {
            ModelAssertion.checkFieldIsPresent(this.fieldName, this.fieldValue);
            Assert.assertEquals((String)this.fieldValue.toString(), (String)expected.toString(), (String)this.errorMessage("is NOT correct,"));
            return this.model;
        }

        public T isNotEmpty() {
            ModelAssertion.checkFieldIsPresent(this.fieldName, this.fieldValue);
            if (this.fieldValue instanceof Collection) {
                Assert.assertNotEquals((Object)this.fieldValue, Collections.emptyList(), (String)this.errorMessage("is empty,"));
            } else if (this.fieldValue instanceof String) {
                Assert.assertNotEquals((Object)this.fieldValue, (Object)"", (String)this.errorMessage("is empty,"));
            } else if (this.fieldValue instanceof Map) {
                Assert.assertNotEquals((Object)this.fieldValue, Collections.emptyMap(), (String)this.errorMessage("is empty,"));
            } else if (this.fieldValue instanceof Integer) {
                Assert.assertNotEquals((Object)this.fieldValue.toString(), (Object)"", (String)this.errorMessage("is empty,"));
            } else if (this.fieldValue instanceof Long) {
                Assert.assertNotEquals((Object)this.fieldValue.toString(), (Object)"", (String)this.errorMessage("is empty,"));
            } else if (this.fieldValue instanceof Boolean) {
                Assert.assertNotEquals((Object)String.valueOf(this.fieldValue), (Object)"", (String)this.errorMessage("is empty,"));
            } else {
                throw new UnsupportedOperationException("Cannot check for emptiness of " + String.valueOf(this.fieldValue.getClass()));
            }
            return this.model;
        }

        public T isNotNull() {
            ModelAssertion.checkFieldIsPresent(this.fieldName, this.fieldValue);
            Assert.assertNotNull((Object)this.fieldValue, (String)this.errorMessage("is null,"));
            return this.model;
        }

        public T isNull() {
            Assert.assertNull((Object)this.fieldValue, (String)this.errorMessage("is not null,"));
            return this.model;
        }

        public T isEmpty() {
            ModelAssertion.checkFieldIsPresent(this.fieldName, this.fieldValue);
            if (this.fieldValue instanceof Collection) {
                Assert.assertEquals((Collection)((Collection)this.fieldValue), Collections.emptyList(), (String)this.errorMessage("is NOT empty,"));
            } else if (this.fieldValue instanceof String) {
                Assert.assertEquals((Object)this.fieldValue, (Object)"", (String)this.errorMessage("is NOT empty,"));
            } else if (this.fieldValue instanceof Map) {
                Assert.assertEquals((Object)this.fieldValue, Collections.emptyMap(), (String)this.errorMessage("is NOT empty,"));
            } else {
                throw new UnsupportedOperationException("Cannot check for emptiness of " + String.valueOf(this.fieldValue.getClass()));
            }
            return this.model;
        }

        public T contains(String value) {
            if (!this.fieldValue.toString().contains(value)) {
                Assert.fail((String)this.errorMessage("does NOT contain expected value: " + value + ", Current Value: " + this.fieldValue.toString()));
            }
            return this.model;
        }

        public T containsOnce(String value) {
            String fieldContent = this.fieldValue.toString();
            int i = fieldContent.indexOf(value);
            if (i == -1) {
                Assert.fail((String)this.errorMessage("does NOT contain at all the expected value: " + value + ", Current Value: " + this.fieldValue.toString()));
            }
            if (i != fieldContent.lastIndexOf(value)) {
                Assert.fail((String)this.errorMessage("contains more than one expected value: " + value + ", Current Value: " + this.fieldValue.toString()));
            }
            return this.model;
        }

        public T notContains(String value) {
            if (this.fieldValue.toString().contains(value)) {
                Assert.fail((String)this.errorMessage("does contain unexpected value: " + value + ", Current Value: " + this.fieldValue.toString()));
            }
            return this.model;
        }

        public T isGreaterThan(Integer value) throws TestConfigurationException {
            return this.validateSize(value, Operation.Greater);
        }

        private T validateSize(Integer value, Operation operation) throws TestConfigurationException {
            try {
                if (value == null) {
                    throw new TestConfigurationException("Input must be valid");
                }
                Integer b = Integer.valueOf(this.fieldValue.toString());
                switch (operation.ordinal()) {
                    case 1: {
                        if (value > b) {
                            Assert.fail((String)this.errorMessage(String.format("The expected value %s is not greater than the actual value %s ", value, this.fieldValue.toString())));
                        }
                        break;
                    }
                    case 0: {
                        if (value < b) {
                            Assert.fail((String)this.errorMessage(String.format("The expected value %s is not less than the actual value %s ", value, this.fieldValue.toString())));
                        }
                        break;
                    }
                    default: {
                        Assert.fail((String)this.errorMessage("No operation type provided"));
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                Assert.fail((String)this.errorMessage("The field is not numeric " + this.fieldValue.toString()));
            }
            catch (NullPointerException ne) {
                Assert.fail((String)this.errorMessage("The input value must be numeric " + value));
            }
            return this.model;
        }

        public T isLessThan(Integer value) throws TestConfigurationException {
            return this.validateSize(value, Operation.Less);
        }
    }

    public class AssertionItemVerbs {
        private Object model;
        private Object actual;

        public AssertionItemVerbs(ModelAssertion this$0, Object model, Object actual) {
            this.model = model;
            this.actual = actual;
        }

        public T is(Object expected) {
            Assert.assertEquals((Object)this.actual, (Object)expected, (String)String.format("For model [%s], the expected value is not correct ", this.model.getClass().getSimpleName(), expected.toString(), this.actual.toString()));
            return this.model;
        }
    }

    private class SerializableTypeAdapterFactory
    implements TypeAdapterFactory {
        private SerializableTypeAdapterFactory(ModelAssertion modelAssertion) {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (Serializable.class.equals((Object)type.getRawType())) {
                return gson.getAdapter(Object.class);
            }
            return null;
        }
    }

    public static enum Operation {
        Less,
        Greater;

    }
}

