/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestGroupMember;
import org.alfresco.rest.model.RestGroupMemberModelsCollection;
import org.alfresco.rest.model.RestGroupsModel;
import org.alfresco.rest.model.RestGroupsModelsCollection;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class Groups
extends ModelRequest<Groups> {
    public Groups(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RestGroupsModelsCollection listGroups() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "groups?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestGroupsModelsCollection.class, request);
    }

    public RestGroupsModel createGroup(String groupBodyCreate) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, groupBodyCreate, "groups?{parameters}", this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestGroupsModel.class, request);
    }

    public RestGroupsModel getGroupDetail(String groupId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "groups/{groupId}?{parameters}", groupId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestGroupsModel.class, request);
    }

    public void deleteGroup(String groupId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "groups/{groupId}?{parameters}", groupId, this.restWrapper.getParameters());
        this.restWrapper.processEmptyModel(request);
    }

    public RestGroupsModel updateGroupDetails(String groupId, String groupBodyUpdate) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, groupBodyUpdate, "groups/{groupId}?{parameters}", groupId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestGroupsModel.class, request);
    }

    public RestGroupMemberModelsCollection listGroupMemberships(String groupId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, "groups/{groupId}/members?{parameters}", groupId, this.restWrapper.getParameters());
        return this.restWrapper.processModels(RestGroupMemberModelsCollection.class, request);
    }

    public RestGroupMember createGroupMembership(String groupId, String groupMembershipBodyCreate) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.POST, groupMembershipBodyCreate, "groups/{groupId}/members?{parameters}", groupId, this.restWrapper.getParameters());
        return this.restWrapper.processModel(RestGroupMember.class, request);
    }

    public void deleteGroupMembership(String groupId, String groupMemberId) {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.DELETE, "groups/{groupId}/members/{groupMemberId}", groupId, groupMemberId);
        this.restWrapper.processEmptyModel(request);
    }
}

