/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.rules;

import org.alfresco.rest.model.RestRuleSettingsModel;
import org.alfresco.rest.rules.RulesRestTest;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.http.HttpStatus;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"rules"})
public class SetInheritanceTests
extends RulesRestTest {
    private UserModel siteOwner;
    private SiteModel site;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() {
        Step.STEP((String)"Create a user, site and folder.");
        this.siteOwner = this.dataUser.createRandomTestUser();
        this.site = ((DataSite)this.dataSite.usingUser(this.siteOwner)).createPrivateRandomSite();
    }

    @Test(groups={"rest-api", "rules"})
    public void getIsInherited() {
        Step.STEP((String)"Create a folder for the test.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        Step.STEP((String)"Get the -isInheritanceEnabled- rule settings for the folder.");
        RestRuleSettingsModel ruleSettingsModel = this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)folder).usingIsInheritanceEnabledRuleSetting().retrieveSetting();
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestRuleSettingsModel expected = new RestRuleSettingsModel();
        expected.setKey("-isInheritanceEnabled-");
        expected.setValue((Object)true);
        ruleSettingsModel.assertThat().isEqualTo((Object)expected, new String[0]);
    }

    @Test(groups={"rest-api", "rules"})
    public void getIsInheritedFromNonExistentFolder() {
        Step.STEP((String)"Try to get the -isInheritanceEnabled- rule settings for a fake folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingIsInheritanceEnabledRuleSetting().retrieveSetting();
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Folder with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void getNonExistentSetting() {
        Step.STEP((String)"Create a folder for the test.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to get a fake setting from the folder.");
        this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)folder).usingRuleSetting("-fakeRuleSetting-").retrieveSetting();
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Unrecognised rule setting key -fakeRuleSetting-");
    }

    @Test(groups={"rest-api", "rules"})
    public void getIsInheritedWithoutPermission() {
        Step.STEP((String)"Create a folder and a user without permission to access it.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        UserModel noPermissionUser = this.dataUser.createRandomTestUser();
        Step.STEP((String)"Try to get the -isInheritanceEnabled- setting without permission.");
        this.restClient.authenticateUser(noPermissionUser).withPrivateAPI().usingNode((RepoTestModel)folder).usingIsInheritanceEnabledRuleSetting().retrieveSetting();
        this.restClient.assertLastError().statusCodeIs(HttpStatus.FORBIDDEN).containsSummary("Cannot read from this node");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateIsInherited() {
        Step.STEP((String)"Create a folder for the test.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        Step.STEP((String)"Set -isInheritanceEnabled- to false.");
        RestRuleSettingsModel updateBody = new RestRuleSettingsModel();
        updateBody.setValue((Object)false);
        RestRuleSettingsModel ruleSettingsModel = this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)folder).usingIsInheritanceEnabledRuleSetting().updateSetting(updateBody);
        this.restClient.assertStatusCodeIs(HttpStatus.OK);
        RestRuleSettingsModel expected = new RestRuleSettingsModel();
        expected.setKey("-isInheritanceEnabled-");
        expected.setValue((Object)false);
        ruleSettingsModel.assertThat().isEqualTo((Object)expected, new String[0]);
    }

    @Test(groups={"rest-api", "rules"})
    public void updateInheritedWithBadValue() {
        Step.STEP((String)"Create a folder for the test.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to set -isInheritanceEnabled- to \"banana\".");
        RestRuleSettingsModel updateBody = new RestRuleSettingsModel();
        updateBody.setValue((Object)"banana");
        this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)folder).usingIsInheritanceEnabledRuleSetting().updateSetting(updateBody);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.BAD_REQUEST).containsSummary("Rule setting -isInheritanceEnabled- requires a boolean value.");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateInheritedWithNonExistentFolder() {
        Step.STEP((String)"Try to set -isInheritanceEnabled- against a fake folder.");
        FolderModel nonExistentFolder = FolderModel.getRandomFolderModel();
        nonExistentFolder.setNodeRef("fake-id");
        RestRuleSettingsModel updateBody = new RestRuleSettingsModel();
        updateBody.setValue((Object)true);
        this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)nonExistentFolder).usingIsInheritanceEnabledRuleSetting().updateSetting(updateBody);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Folder with id fake-id was not found");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateNonExistentSetting() {
        Step.STEP((String)"Create a folder for the test.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        Step.STEP((String)"Try to set a fake setting on the folder.");
        RestRuleSettingsModel updateBody = new RestRuleSettingsModel();
        updateBody.setValue((Object)true);
        this.restClient.authenticateUser(this.siteOwner).withPrivateAPI().usingNode((RepoTestModel)folder).usingRuleSetting("-fakeRuleSetting-").updateSetting(updateBody);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.NOT_FOUND).containsSummary("Unrecognised rule setting key -fakeRuleSetting-");
    }

    @Test(groups={"rest-api", "rules"})
    public void updateIsInheritedWithoutPermission() {
        Step.STEP((String)"Create a folder and a collaborator.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.siteOwner).usingSite(this.site)).createFolder();
        UserModel collaborator = this.dataUser.createRandomTestUser();
        collaborator.setUserRole(UserRole.SiteCollaborator);
        this.restClient.authenticateUser(this.siteOwner).withCoreAPI().usingSite(this.site).addPerson(collaborator);
        Step.STEP((String)"Try to update the -isInheritanceEnabled- setting without permission.");
        RestRuleSettingsModel updateBody = new RestRuleSettingsModel();
        updateBody.setValue((Object)true);
        this.restClient.authenticateUser(collaborator).withPrivateAPI().usingNode((RepoTestModel)folder).usingIsInheritanceEnabledRuleSetting().updateSetting(updateBody);
        this.restClient.assertLastError().statusCodeIs(HttpStatus.FORBIDDEN).containsSummary("Insufficient permissions to manage rules");
    }
}

