/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.requests;

import org.alfresco.rest.core.RestRequest;
import org.alfresco.rest.core.RestWrapper;
import org.alfresco.rest.model.RestRuleSettingsModel;
import org.alfresco.rest.requests.FolderRules;
import org.alfresco.rest.requests.ModelRequest;
import org.springframework.http.HttpMethod;

public class RuleSettings
extends ModelRequest<FolderRules> {
    public static final String IS_INHERITANCE_ENABLED = "-isInheritanceEnabled-";
    private static final String BASE_PATH = "nodes/{nodeId}/rule-settings/{ruleSettingKey}";
    private String nodeId;
    private String ruleSettingKey;

    public RuleSettings(RestWrapper restWrapper) {
        super(restWrapper);
    }

    public RuleSettings withNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public RuleSettings withRuleSettingKey(String ruleSettingKey) {
        this.ruleSettingKey = ruleSettingKey;
        return this;
    }

    public RestRuleSettingsModel retrieveSetting() {
        RestRequest request = RestRequest.simpleRequest(HttpMethod.GET, BASE_PATH, this.nodeId, this.ruleSettingKey);
        return this.restWrapper.processModel(RestRuleSettingsModel.class, request);
    }

    public RestRuleSettingsModel updateSetting(RestRuleSettingsModel ruleSettingsModel) {
        RestRequest request = RestRequest.requestWithBody(HttpMethod.PUT, ruleSettingsModel.toJson(), BASE_PATH, this.nodeId, this.ruleSettingKey);
        return this.restWrapper.processModel(RestRuleSettingsModel.class, request);
    }
}

