/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.rest.RestTest;
import org.alfresco.rest.model.RestSizeDetailsModel;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.data.DataSite;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FileType;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.RepoTestModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.apache.commons.lang3.RandomStringUtils;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.springframework.http.HttpStatus;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class NodeSizeDetailsTests
extends RestTest {
    private UserModel user1;
    private SiteModel siteModel;
    private FolderModel folder;
    private String jobId;
    private FileModel sampleFileToCreate;
    private long sampleFileSize;

    @BeforeClass(alwaysRun=true)
    public void dataPreparation() throws IOException {
        this.user1 = this.dataUser.createRandomTestUser("User-1");
        this.siteModel = ((DataSite)this.dataSite.usingUser(this.user1)).createPublicRandomSite();
        this.folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        String fileName = "sampleLargeContent.txt";
        byte[] sampleFileContent = this.getSampleFileContent(fileName);
        this.sampleFileSize = sampleFileContent.length;
        this.sampleFileToCreate = new FileModel(fileName, FileType.TEXT_PLAIN, new String(sampleFileContent));
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void calculateNodeSizeForSingleFile() throws Exception {
        Step.STEP((String)"1. Create a folder in the test site.");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Upload a text document to the folder.");
        ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)this.folder)).createContent(this.sampleFileToCreate);
        Step.STEP((String)"3. Wait for 30 seconds so that the content is indexed in Search Service.");
        Utility.waitToLoopTime((int)30, (String[])new String[0]);
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        this.jobId = restSizeDetailsModel.getJobId();
        Step.STEP((String)"4. Wait for 5 seconds for the processing to complete.");
        Awaitility.await().atMost(Duration.ofSeconds(5L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            RestSizeDetailsModel sizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).getSizeDetails(this.jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            sizeDetailsModel.assertThat().field("sizeInBytes").isNotEmpty();
            Assert.assertEquals((Long)sizeDetailsModel.getSizeInBytes(), (long)this.sampleFileSize, (String)("Value of sizeInBytes " + sizeDetailsModel.getSizeInBytes() + " is not equal to " + this.sampleFileSize));
        });
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void calculateNodeSizeForEmptyFolder() throws Exception {
        Step.STEP((String)"1. Create a folder in the test site.");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        this.jobId = restSizeDetailsModel.getJobId();
        Step.STEP((String)"2. Wait for 5 seconds for the processing to complete.");
        Awaitility.await().atMost(Duration.ofSeconds(5L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            RestSizeDetailsModel sizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).getSizeDetails(this.jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            sizeDetailsModel.assertThat().field("sizeInBytes").isNotEmpty();
            Assert.assertEquals((Long)sizeDetailsModel.getSizeInBytes(), (long)0L, (String)("Value of sizeInBytes should be 0 " + sizeDetailsModel.getSizeInBytes()));
            Assert.assertEquals((String)sizeDetailsModel.getStatus().name(), (String)"COMPLETED", (String)("Status should be - COMPLETED" + sizeDetailsModel.getStatus().name()));
        });
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkJobIdPresentInCache() throws Exception {
        Step.STEP((String)"1. Verifying that same JobId is coming or not");
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        Assert.assertEquals((String)restSizeDetailsModel.getJobId(), (String)this.jobId, (String)("jobId should be present in cache, actual :" + restSizeDetailsModel.getJobId() + " expected: " + this.jobId));
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkSizeDetailsWithInvalidJobId() throws Exception {
        Step.STEP((String)"1. Create a folder in the test site.");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Upload a text document to the folder.");
        ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)this.folder)).createContent(this.sampleFileToCreate);
        Step.STEP((String)"3. Wait for 30 seconds so that the content is indexed in Search Service.");
        Utility.waitToLoopTime((int)30, (String[])new String[0]);
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        this.jobId = restSizeDetailsModel.getJobId();
        Step.STEP((String)"4. Adding random content to jobId ");
        this.jobId = this.jobId + RandomStringUtils.randomAlphanumeric((int)2);
        Step.STEP((String)"5. Wait for 10 seconds for the processing to complete.");
        Awaitility.await().atMost(Duration.ofSeconds(10L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).getSizeDetails(this.jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
        });
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkSizeDetailsWithoutExecuteSizeDetails() throws Exception {
        Step.STEP((String)"1. Create a folder in the test site.");
        this.folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Upload a text document to the folder.");
        String status = "NOT_INITIATED";
        FileModel fileModel = ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)this.folder)).createContent(this.sampleFileToCreate);
        Assert.assertNotNull((Object)fileModel, (String)"fileModel should not be null");
        Step.STEP((String)"3. Wait for 30 seconds so that the content is indexed in Search Service.");
        Awaitility.await().atMost(Duration.ofSeconds(30L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            RestSizeDetailsModel sizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).getSizeDetails(this.jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            sizeDetailsModel.assertThat().field("status").isNotEmpty();
            Assert.assertEquals((String)sizeDetailsModel.getStatus().toString(), (String)status, (String)("Value of status should be same, actual :" + sizeDetailsModel.getStatus().toString() + " expected: " + status));
        });
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void unauthenticatedUserIsNotAbleGetSizeDetails() {
        this.restClient.authenticateUser(new UserModel("random user", "random password"));
        this.restClient.withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.UNAUTHORIZED);
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void nodeIdNotExist() {
        this.folder.setNodeRef(RandomStringUtils.randomAlphanumeric((int)20));
        this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)this.folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.NOT_FOUND);
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void nodeIdNotValid() {
        FileModel document = ((DataContent)this.dataContent.usingSite(this.siteModel)).usingUser(this.user1).createContent(CMISUtil.DocumentType.TEXT_PLAIN);
        this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)document).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.UNPROCESSABLE_ENTITY);
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void calculateNodeSizeForMultipleFiles() throws InterruptedException {
        Step.STEP((String)"1. Create a parent folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Creating a 5 nested folders in the folder-1");
        AtomicLong fileSize = new AtomicLong(0L);
        IntStream.rangeClosed(1, 5).forEach(i -> {
            String folder0Name = "childFolder" + i + RandomStringUtils.randomAlphanumeric((int)2);
            FolderModel folderModel = new FolderModel();
            folderModel.setName(folder0Name);
            FolderModel childFolder = ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)folder)).createFolder(folderModel);
            Step.STEP((String)"3. Upload a text document to the childFolders.");
            ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)childFolder)).createContent(this.sampleFileToCreate);
            fileSize.addAndGet(this.sampleFileSize);
        });
        Step.STEP((String)"4. Wait for 30 seconds so that the content is indexed in Search Service.");
        Utility.waitToLoopTime((int)30, (String[])new String[0]);
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        String jobId = restSizeDetailsModel.getJobId();
        Step.STEP((String)"5. Wait for 5 seconds for the processing to complete.");
        Awaitility.await().atMost(Duration.ofSeconds(5L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            RestSizeDetailsModel sizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)folder).getSizeDetails(jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            sizeDetailsModel.assertThat().field("sizeInBytes").isNotEmpty();
            Assert.assertEquals((Long)sizeDetailsModel.getSizeInBytes(), (long)fileSize.get(), (String)("Value of sizeInBytes " + sizeDetailsModel.getSizeInBytes() + " is not equal to " + fileSize.get()));
        });
    }

    @TestRail(section={"rest-api", "nodes"}, executionType={ExecutionType.SANITY})
    @Test(groups={"rest-api", "nodes", "sanity"})
    public void checkNumberOfFiles() throws InterruptedException {
        Step.STEP((String)"1. Create a parent folder in the test site.");
        FolderModel folder = ((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).createFolder(FolderModel.getRandomFolderModel());
        Step.STEP((String)"2. Creating a 10 nested folders in the folder-1");
        IntStream.rangeClosed(1, 10).forEach(i -> {
            String folder0Name = "childFolder" + i + RandomStringUtils.randomAlphanumeric((int)2);
            FolderModel folderModel = new FolderModel();
            folderModel.setName(folder0Name);
            FolderModel childFolder = ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)folder)).createFolder(folderModel);
            Step.STEP((String)"3. Upload a text document to the childFolders.");
            ((DataContent)((DataContent)this.dataContent.usingUser(this.user1).usingSite(this.siteModel)).usingResource((ContentModel)childFolder)).createContent(this.sampleFileToCreate);
        });
        Step.STEP((String)"4. Wait for 30 seconds so that the content is indexed in Search Service.");
        Utility.waitToLoopTime((int)30, (String[])new String[0]);
        RestSizeDetailsModel restSizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)folder).executeSizeDetails();
        this.restClient.assertStatusCodeIs(HttpStatus.ACCEPTED);
        restSizeDetailsModel.assertThat().field("jobId").isNotEmpty();
        String jobId = restSizeDetailsModel.getJobId();
        Step.STEP((String)"5. Wait for 10 seconds for the processing to complete.");
        Awaitility.await().atMost(Duration.ofSeconds(10L)).pollInterval(Durations.ONE_SECOND).ignoreExceptions().untilAsserted(() -> {
            RestSizeDetailsModel sizeDetailsModel = this.restClient.authenticateUser(this.user1).withCoreAPI().usingNode((RepoTestModel)folder).getSizeDetails(jobId);
            this.restClient.assertStatusCodeIs(HttpStatus.OK);
            sizeDetailsModel.assertThat().field("numberOfFiles").isNotEmpty();
            Assert.assertEquals((Integer)sizeDetailsModel.getNumberOfFiles(), (int)10, (String)("Value of NumberOfFiles " + sizeDetailsModel.getNumberOfFiles() + " is not equal to 10"));
        });
    }

    private byte[] getSampleFileContent(String fileName) throws IOException {
        String fileClasspathLocation = "/shared-resources/testdata/" + fileName;
        try (InputStream fileStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileClasspathLocation);){
            Objects.requireNonNull(fileStream, "Couldn't locate `" + fileClasspathLocation + "`");
            byte[] byArray = fileStream.readAllBytes();
            return byArray;
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanup() throws Exception {
        ((DataSite)this.dataSite.usingUser(this.user1)).deleteSite(this.siteModel);
    }
}

