/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.rest.core;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Random;
import org.alfresco.rest.core.IRestModel;
import org.alfresco.rest.core.IRestModelsCollection;
import org.alfresco.rest.core.assertion.IModelsCollectionAssertion;
import org.alfresco.rest.core.assertion.ModelsCollectionAssertion;
import org.alfresco.rest.exception.EmptyRestModelCollectionException;
import org.alfresco.rest.model.RestPaginationModel;
import org.alfresco.utility.report.log.Step;

public abstract class RestModels<Model, ModelCollection>
implements IRestModelsCollection<Model>,
IModelsCollectionAssertion<ModelCollection> {
    @JsonProperty(value="entries")
    private List<Model> modelEntries;
    private RestPaginationModel pagination;

    @Override
    public List<Model> getEntries() {
        return this.modelEntries;
    }

    @Override
    public Model getOneRandomEntry() throws EmptyRestModelCollectionException {
        Step.STEP((String)"REST API: Get random one entry from response");
        Random random = new Random();
        List<Model> models = this.getEntries();
        if (models.isEmpty()) {
            throw new EmptyRestModelCollectionException(models);
        }
        int index = random.nextInt(models.size());
        return models.get(index);
    }

    public Model getEntryByIndex(int index) throws EmptyRestModelCollectionException {
        Step.STEP((String)"REST API: Get index entry from response");
        List<Model> models = this.getEntries();
        if (models.isEmpty()) {
            throw new EmptyRestModelCollectionException(models);
        }
        if (models.size() > index) {
            return ((IRestModel)models.get(index)).onModel();
        }
        return null;
    }

    @Override
    public ModelsCollectionAssertion<RestModels<Model, ModelCollection>> assertThat() {
        return new ModelsCollectionAssertion<RestModels<Model, ModelCollection>>(this);
    }

    @Override
    public ModelsCollectionAssertion<RestModels<Model, ModelCollection>> and() {
        return this.assertThat();
    }

    @Override
    public ModelCollection when() {
        return (ModelCollection)this;
    }

    @Override
    public boolean isEmpty() {
        if (this.getEntries() != null) {
            return this.getEntries().isEmpty();
        }
        return true;
    }

    @Override
    public RestPaginationModel getPagination() {
        return this.pagination;
    }

    public void setPagination(RestPaginationModel pagination) {
        this.pagination = pagination;
    }
}

