/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:default.properties"}), @PropertySource(value={"classpath:${environment}.properties"}, ignoreResourceNotFound=true)})
public class TasProperties {
    @Autowired
    Environment env;
    @Value(value="${admin.user:admin}")
    private String adminUserName;
    @Value(value="${admin.password:admin}")
    private String adminPassword;
    @Value(value="${alfresco.scheme:http}")
    private String scheme;
    @Value(value="${alfresco.server:localhost}")
    private String server;
    @Value(value="${alfresco.port:8070}")
    private int port;
    @Value(value="${jmx.user:controlRole}")
    private String jmxUser;
    @Value(value="${jmx.password:change_asap}")
    private String jmxPassword;
    @Value(value="${jmx.port:50500}")
    private String jmxPort;
    @Value(value="${jmx.useJolokiaAgent:true}")
    private Boolean useJolokiaJmxAgent;
    @Value(value="${db.url:localhost}")
    private String dbUrl;
    @Value(value="${db.username:alfresco}")
    private String dbUsername;
    @Value(value="${db.password:alfresco}")
    private String dbPassword;
    @Value(value="${serverHealth.showTenants:true}")
    private Boolean showTenantsOnServerHealth;
    @Value(value="${browser.name:Firefox}")
    private String browserName;
    @Value(value="${browser.version:41}")
    private String browserVersion;
    @Value(value="${browser.implicitWait:10}")
    private long implicitWait;
    @Value(value="${browser.explicitWait:30}")
    private long explicitWait;
    @Value(value="${grid.url:not-set}")
    private String gridUrl;
    @Value(value="${grid.enabled:false}")
    private boolean gridEnabled;
    @Value(value="${screenshots.dir:screenshots}")
    private File screenshotsDir;
    @Value(value="${env.platform:WINDOWS}")
    private String envPlatformName;
    @Value(value="${share.url:http://localhost}")
    private URL shareUrl;
    @Value(value="${auth.context.factory:com.sun.jndi.ldap.LdapCtxFactory}")
    private String authContextFactory;
    @Value(value="${auth.security.authentication:simple}")
    private String securityAuth;
    @Value(value="${oracle.url:ldap://172.29.100.111:2389}")
    private String oracleURL;
    @Value(value="${oracle.security.principal:cn=Directory Manager}")
    private String oracleSecurityPrincipal;
    @Value(value="${oracle.security.credentials:directory}")
    private String oracleSecurityCredentials;
    @Value(value="${ldap.url:ldap://172.29.100.119:389}")
    private String ldapURL;
    @Value(value="${ldap.search.base:CN=Users,DC=alfresconess,DC=com}")
    private String ldapSearchBase;
    @Value(value="${ldap2.search.base:CN=Users,DC=alfresconess2,DC=com}")
    private String ldapSearchBase2;
    @Value(value="${ldap.security.principal:CN=Administrator,CN=Users,DC=alfness,DC=com}")
    private String ldapSecurityPrincipal;
    @Value(value="${ldap.security.credentials:Alf1234}")
    private String ldapSecurityCredentials;
    @Value(value="${ldap2.url:ldap://1/52.213.122.208:389}")
    private String ldap2URL;
    @Value(value="${ldap2.security.principal:CN=Administrator,CN=Users,DC=alfness,DC=com}")
    private String ldap2SecurityPrincipal;
    @Value(value="${ldap2.security.credentials:Alf1234}")
    private String ldap2SecurityCredentials;
    @Value(value="${oldap.url:ldap://172.29.100.226:389}")
    private String oldapURL;
    @Value(value="${oldap.security.principal:CN=admin,DC=alfness,DC=com}")
    private String oldapSecurityPrincipal;
    @Value(value="${oldap.security.credentials:Alf1234}")
    private String oldapSecurityCredentials;
    @Value(value="${ntlm.host:172.29.100.126}")
    private String ntlmHost;
    @Value(value="${ntlm.security.principal:alfntlm\\Administrator}")
    private String ntlmSecurityPrincipal;
    @Value(value="${ntlm.security.credentials:Alf1234}")
    private String ntlmSecurityCredentials;
    @Value(value="${sync.scheme:http}")
    private String syncScheme;
    @Value(value="${sync.server:localhost}")
    private String syncServer;
    @Value(value="${sync.port:9090}")
    private int syncPort;
    @Value(value="${browser.language:en}")
    private String browserLanguage;
    @Value(value="${browser.language.country:gb}")
    private String browserLanguageCountry;
    @Value(value="${solrWaitTimeInSeconds:60}")
    private int solrWaitTimeInSeconds;
    @Value(value="${solr.scheme:http}")
    private String solrScheme;
    @Value(value="${solr.server:localhost}")
    private String solrServer;
    @Value(value="${solr.port:8983}")
    private int solrPort;
    @Value(value="${solr.secretName:X-Alfresco-Search-Secret}")
    private String solrSecretName;
    @Value(value="${solr.secret:}")
    private String solrSecret;
    @Value(value="${display.xport:1}")
    private String displayXport;

    public Boolean showTenantsOnServerHealth() {
        return this.showTenantsOnServerHealth;
    }

    public boolean useJolokiaJmxAgent() {
        return this.useJolokiaJmxAgent;
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    public Environment getEnv() {
        return this.env;
    }

    public String getAdminUser() {
        return this.adminUserName;
    }

    public void setAdminUserName(String adminUserName) {
        this.adminUserName = adminUserName;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getJmxUser() {
        return this.jmxUser;
    }

    public void setJmxUser(String jmxUser) {
        this.jmxUser = jmxUser;
    }

    public String getJmxPassword() {
        return this.jmxPassword;
    }

    public void setJmxPassword(String jmxPassword) {
        this.jmxPassword = jmxPassword;
    }

    public String getJmxPort() {
        return this.jmxPort;
    }

    public void setJmxPort(String jmxPort) {
        this.jmxPort = jmxPort;
    }

    public String getJmxUrl() {
        return String.format("service:jmx:rmi:///jndi/rmi://%s:%s/alfresco/jmxrmi", this.getServer(), this.getJmxPort());
    }

    public String getFullServerUrl() {
        return new UrlBuilder(this.getScheme(), this.getServer(), this.getPort(), "").toString();
    }

    public String getTestServerUrl() {
        return String.format("%s://%s", this.getScheme(), this.getServer());
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public void setBrowserName(String browserName) {
        this.browserName = browserName;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public long getImplicitWait() {
        return this.implicitWait;
    }

    public void setImplicitWait(long implicitWait) {
        this.implicitWait = implicitWait;
    }

    public long getExplicitWait() {
        return this.explicitWait;
    }

    public void setExplicitWait(long explicitWait) {
        this.explicitWait = explicitWait;
    }

    public URL getGridUrl() throws MalformedURLException {
        return new URL(this.gridUrl);
    }

    public void setGridUrl(String gridUrl) {
        this.gridUrl = gridUrl;
    }

    public boolean isGridEnabled() {
        return this.gridEnabled;
    }

    public void setGridEnabled(boolean gridEnabled) {
        this.gridEnabled = gridEnabled;
    }

    public File getScreenshotsDir() {
        return this.screenshotsDir;
    }

    public void setScreenshotsDir(String screenshotsDir) {
        File f = Paths.get(screenshotsDir, new String[0]).toFile();
        if (f.isFile() && !f.exists()) {
            f.getParentFile().mkdirs();
        } else if (!f.exists()) {
            f.mkdirs();
        }
        this.screenshotsDir = f;
    }

    public String getLdapSearchBase() {
        return this.ldapSearchBase;
    }

    public void setLdapSearchBase(String ldapSearchBase) {
        this.ldapSearchBase = ldapSearchBase;
    }

    public String getLdapSearchBase2() {
        return this.ldapSearchBase2;
    }

    public void setLdapSearchBase2(String ldapSearchBase2) {
        this.ldapSearchBase2 = ldapSearchBase2;
    }

    public String getEnvPlatformName() {
        return this.envPlatformName;
    }

    public void setEnvPlatformName(String envPlatformName) {
        this.envPlatformName = envPlatformName;
    }

    public URL getShareUrl() {
        return this.shareUrl;
    }

    public void setShareUrl(URL shareUrl) {
        this.shareUrl = shareUrl;
    }

    public String getAuthContextFactory() {
        return this.authContextFactory;
    }

    public void setAuthContextFactory(String authContextFactory) {
        this.authContextFactory = authContextFactory;
    }

    public String getSecurityAuth() {
        return this.securityAuth;
    }

    public String getSyncServerUrl() {
        return String.format("%s://%s", this.getSyncScheme(), this.getSyncServer());
    }

    public void setSecurityAuth(String securityAuth) {
        this.securityAuth = securityAuth;
    }

    public String getOracleURL() {
        return this.oracleURL;
    }

    public void setOracleURL(String oracleURL) {
        this.oracleURL = oracleURL;
    }

    public String getOracleSecurityPrincipal() {
        return this.oracleSecurityPrincipal;
    }

    public void setOracleSecurityPrincipal(String oracleSecurityPrincipal) {
        this.oracleSecurityPrincipal = oracleSecurityPrincipal;
    }

    public String getOracleSecurityCredentials() {
        return this.oracleSecurityCredentials;
    }

    public void setOracleSecurityCredentials(String oracleSecurityCredentials) {
        this.oracleSecurityCredentials = oracleSecurityCredentials;
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    public String getLdap2URL() {
        return this.ldap2URL;
    }

    public void setLdapURL(String ldapURL) {
        this.ldapURL = ldapURL;
    }

    public void setLdap2URL(String ldap2URL) {
        this.ldap2URL = ldap2URL;
    }

    public String getLdapSecurityPrincipal() {
        return this.ldapSecurityPrincipal;
    }

    public String getLdap2SecurityPrincipal() {
        return this.ldap2SecurityPrincipal;
    }

    public void setLdapSecurityPrincipal(String ldapSecurityPrincipal) {
        this.ldapSecurityPrincipal = ldapSecurityPrincipal;
    }

    public void setLdap2SecurityPrincipal(String ldap2SecurityPrincipal) {
        this.ldap2SecurityPrincipal = ldap2SecurityPrincipal;
    }

    public String getLdapSecurityCredentials() {
        return this.ldapSecurityCredentials;
    }

    public String getLdap2SecurityCredentials() {
        return this.ldap2SecurityCredentials;
    }

    public void setLdapSecurityCredentials(String ldapSecurityCredentials) {
        this.ldapSecurityCredentials = ldapSecurityCredentials;
    }

    public void setLdap2SecurityCredentials(String ldap2SecurityCredentials) {
        this.ldap2SecurityCredentials = ldap2SecurityCredentials;
    }

    public String getOLdapURL() {
        return this.oldapURL;
    }

    public void setOLdapURL(String oldapURL) {
        this.oldapURL = oldapURL;
    }

    public String getOLdapSecurityPrincipal() {
        return this.oldapSecurityPrincipal;
    }

    public void setOLdapSecurityPrincipal(String oldapSecurityPrincipal) {
        this.oldapSecurityPrincipal = oldapSecurityPrincipal;
    }

    public String getOLdapSecurityCredentials() {
        return this.oldapSecurityCredentials;
    }

    public void setOLdapSecurityCredentials(String oldapSecurityCredentials) {
        this.oldapSecurityCredentials = oldapSecurityCredentials;
    }

    public String getNtlmHost() {
        return this.ntlmHost;
    }

    public void setNtlmHost(String ntlmHost) {
        this.ntlmHost = ntlmHost;
    }

    public String getNtlmSecurityPrincipal() {
        return this.ntlmSecurityPrincipal;
    }

    public void setNtlmSecurityPrincipal(String ntlmSecurityPrincipal) {
        this.ntlmSecurityPrincipal = ntlmSecurityPrincipal;
    }

    public String getNtlmSecurityCredentials() {
        return this.ntlmSecurityCredentials;
    }

    public void setNtlmSecurityCredentials(String ntlmSecurityCredentials) {
        this.ntlmSecurityCredentials = ntlmSecurityCredentials;
    }

    public String getSyncScheme() {
        return this.syncScheme;
    }

    public void setSyncScheme(String syncScheme) {
        this.syncScheme = syncScheme;
    }

    public String getSyncServer() {
        return this.syncServer;
    }

    public void setSyncServer(String syncServer) {
        this.syncServer = syncServer;
    }

    public int getSyncPort() {
        return this.syncPort;
    }

    public void setSyncPort(int syncPort) {
        this.syncPort = syncPort;
    }

    public String getBrowserLanguage() {
        return this.browserLanguage;
    }

    public void setBrowserLanguage(String browserLanguage) {
        this.browserLanguage = browserLanguage;
    }

    public String getBrowserLanguageCountry() {
        return this.browserLanguageCountry;
    }

    public void setBrowserLanguageCountry(String browserLanguageCountry) {
        this.browserLanguageCountry = browserLanguageCountry;
    }

    public int getSolrWaitTimeInSeconds() {
        return this.solrWaitTimeInSeconds;
    }

    public void setSolrWaitTimeInSeconds(int solrWaitTimeInSeconds) {
        this.solrWaitTimeInSeconds = solrWaitTimeInSeconds;
    }

    public String getSolrScheme() {
        return this.solrScheme;
    }

    public void setSolrScheme(String solrScheme) {
        this.solrScheme = solrScheme;
    }

    public String getSolrServer() {
        return this.solrServer;
    }

    public void setSolrServer(String solrServer) {
        this.solrServer = solrServer;
    }

    public int getSolrPort() {
        return this.solrPort;
    }

    public void setSolrPort(int solrPort) {
        this.solrPort = solrPort;
    }

    public String getSolrSecretName() {
        return this.solrSecretName;
    }

    public void setSolrSecretName(String solrSecretName) {
        this.solrSecretName = solrSecretName;
    }

    public String getSolrSecret() {
        return this.solrSecret;
    }

    public void setSolrSecret(String solrSecret) {
        this.solrSecret = solrSecret;
    }

    public String getSolrServerUrl() {
        return String.format("%s://%s", this.getSolrScheme(), this.getSolrServer());
    }

    public String getDisplayXport() {
        return this.displayXport;
    }
}

