/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.RetryOperation;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.exception.TestObjectNotDefinedException;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.testrail.TestRailExecutorListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.testng.Assert;

public class Utility {
    static Logger LOG = LogFactory.getLogger();
    public static int retryCountSeconds = 15;

    public static void checkObjectIsInitialized(Object model, String message) throws TestObjectNotDefinedException {
        if (model == null) {
            throw new TestObjectNotDefinedException(message);
        }
    }

    public static File getTestResourceFile(String filePath) throws TestConfigurationException {
        LOG.info("Get resource file {}", (Object)filePath);
        URL resource = Utility.class.getClassLoader().getResource(filePath);
        if (resource == null) {
            throw new TestConfigurationException(String.format("[%s] file was not found in your main resources folder.", filePath));
        }
        return new File(resource.getFile());
    }

    public static File getResourceTestDataFile(String fileName) throws TestConfigurationException {
        return Utility.getTestResourceFile("shared-resources/testdata/" + fileName);
    }

    public static String getResourceTestDataContent(String fileName) throws TestConfigurationException {
        StringBuilder result = new StringBuilder();
        File file = Utility.getResourceTestDataFile(fileName);
        try (Scanner scanner = new Scanner(file);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                result.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new TestConfigurationException(String.format("Cannot read from file %s. Error thrown: %s", fileName, e.getMessage()));
        }
        return result.toString();
    }

    public static String convertBackslashToSlash(String value) {
        if (SystemUtils.IS_OS_WINDOWS) {
            value = value.replace("\\", "/");
        }
        return value;
    }

    public static String cmisDocTypeToExtentions(CMISUtil.DocumentType cmisDocumentType) {
        switch (cmisDocumentType) {
            case TEXT_PLAIN: {
                return "txt";
            }
            case HTML: {
                return "html";
            }
            case MSEXCEL: {
                return "xls";
            }
            case MSPOWERPOINT: {
                return "ppt";
            }
            case MSWORD: {
                return "doc";
            }
            case PDF: {
                return "pdf";
            }
            case XML: {
                return "xml";
            }
        }
        return "txt";
    }

    public static String buildPath(String parent, String ... paths) {
        StringBuilder concatenatedPaths = new StringBuilder(parent);
        int lenPaths = paths.length;
        if (lenPaths == 0) {
            return concatenatedPaths.toString();
        }
        if (!parent.endsWith("/")) {
            concatenatedPaths.append("/");
        }
        for (String path : paths) {
            if (path.isEmpty()) continue;
            if (path.substring(0, 1).equals("/")) {
                path = path.replaceFirst("/", "");
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            concatenatedPaths.append(path);
            concatenatedPaths.append("/");
        }
        String concatenated = concatenatedPaths.toString();
        if (lenPaths > 0 && paths[lenPaths - 1].contains(".")) {
            concatenated = StringUtils.removeEnd((String)concatenated, (String)"/");
        }
        return concatenated;
    }

    public static String getParentPath(String fullPath) {
        String[] path = fullPath.split("/");
        String fileName = path[path.length - 1];
        return fullPath.replace(fileName, "");
    }

    public static String removeLastSlash(String sourcePath) {
        if (StringUtils.endsWith((CharSequence)sourcePath, (CharSequence)"/")) {
            sourcePath = StringUtils.removeEnd((String)sourcePath, (String)"/");
        }
        if (sourcePath.isEmpty()) {
            sourcePath = "/";
        }
        return sourcePath;
    }

    public static Properties getProperties(Class<?> classz, String propertieFileName) throws TestConfigurationException {
        InputStream propsStream = classz.getClassLoader().getResourceAsStream(propertieFileName);
        Properties props = new Properties();
        if (propsStream != null) {
            try {
                props.load(propsStream);
            }
            catch (Exception e) {
                throw new TestConfigurationException(String.format("Cannot load properties from %s file", propertieFileName));
            }
        } else {
            throw new TestConfigurationException(String.format("Cannot initialize properties from %s file", propertieFileName));
        }
        return props;
    }

    public static boolean isPropertyEnabled(String key) {
        boolean isEnabled = false;
        try {
            Properties properties = Utility.getProperties(TestRailExecutorListener.class, Utility.getEnvironmentPropertyFile());
            isEnabled = Boolean.valueOf(Utility.getSystemOrFileProperty(key, properties));
        }
        catch (TestConfigurationException e1) {
            System.err.println("Cannot read properties from '" + Utility.getEnvironmentPropertyFile() + "'. Error: " + e1.getMessage());
        }
        return isEnabled;
    }

    public static void waitToLoopTime(int seconds, String ... info) {
        long endTime;
        LOG.info("Wait until {} second(s) are passed. {}", (Object)seconds, (Object)StringUtils.join((Object[])info, (char)' '));
        long currentTime = System.currentTimeMillis();
        while ((endTime = System.currentTimeMillis()) - currentTime < (long)(seconds * 1000)) {
        }
    }

    public static void sleep(int interval, int maxTime, RetryOperation callback) throws InterruptedException {
        long currentTime = System.currentTimeMillis();
        long endTime = 0L;
        while (true) {
            try {
                endTime = System.currentTimeMillis();
                callback.execute();
            }
            catch (AssertionError | Exception e) {
                if (endTime - currentTime > (long)maxTime) {
                    throw new AssertionError("Maximum retry period reached, test failed.", (Throwable)e);
                }
                Thread.sleep(interval);
                continue;
            }
            break;
        }
    }

    public static String prettyPrintJsonString(String unformattedJson) {
        String prettyPrint = null;
        try {
            JSONObject jsonObject = new JSONObject(unformattedJson);
            prettyPrint = jsonObject.toString(3);
        }
        catch (JSONException ex) {
            prettyPrint = ex.getMessage();
        }
        return prettyPrint;
    }

    public static String toUrlParams(String url, Map<String, String> params) {
        ArrayList<CallSite> listOfParams = new ArrayList<CallSite>();
        for (String param : params.keySet()) {
            listOfParams.add((CallSite)((Object)(param + "=" + params.get(param))));
        }
        if (!listOfParams.isEmpty()) {
            String queryParam = StringUtils.join(listOfParams, (String)"&");
            int quotePosition = url.indexOf("?");
            int hpos = url.indexOf("#");
            char separator = quotePosition == -1 ? (char)'?' : '&';
            String segment = separator + queryParam;
            return hpos == -1 ? url + segment : url.substring(0, hpos) + segment + url.substring(hpos);
        }
        return url;
    }

    public static String getEnvironmentPropertyFile() {
        String envPropName = System.getProperty("environment");
        envPropName = envPropName == null ? "default.properties" : String.format("%s.properties", envPropName);
        return envPropName;
    }

    public static String splitGuidVersion(String guidWithVersion) {
        if (guidWithVersion != null && guidWithVersion.contains(";")) {
            return guidWithVersion.split(";")[0];
        }
        return guidWithVersion;
    }

    public static File checkFileInPath(String fileName, String path) {
        File directory = new File(path);
        File[] list = directory.listFiles();
        if (list == null) {
            return null;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                Utility.checkFileInPath(fileName, f.getAbsolutePath());
                continue;
            }
            if (!f.getName().equals(fileName)) continue;
            return f;
        }
        return null;
    }

    public static File getFileWithSize(String fileName, int sizeMB) {
        byte[] buffer = Utility.getRandomString(0x100000).getBytes();
        int number_of_lines = sizeMB;
        try (FileChannel rwChannel = new RandomAccessFile(fileName, "rw").getChannel();){
            MappedByteBuffer wrBuf = rwChannel.map(FileChannel.MapMode.READ_WRITE, 0L, buffer.length * number_of_lines);
            for (int i = 0; i < number_of_lines; ++i) {
                wrBuf.put(buffer);
            }
        }
        catch (IOException e) {
            throw new DataPreparationException(e);
        }
        File file1 = new File(fileName);
        return file1;
    }

    private static String getRandomString(int length) {
        Random RANDOM = new Random();
        char[] from = "abcdefghijklmnopqrstuvwxyz".toCharArray();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            result.append(from[RANDOM.nextInt(from.length - 1)]);
        }
        return result.toString();
    }

    public static String getSystemOrFileProperty(String key, Properties properties) {
        String value = System.getProperty(key);
        if (value == null) {
            return properties.getProperty(key);
        }
        return value;
    }

    public static void executeOnUnixNoWait(String command) throws IOException {
        String[] com = new String[]{"/bin/sh", "-c", command + " &"};
        LOG.info("On Unix execute command(no wait): [{}]", (Object)command);
        Runtime.getRuntime().exec(com);
    }

    public static String executeOnUnix(String command) {
        LOG.info("On Unix execute command: [{}]", (Object)command);
        StringBuilder sb = new StringBuilder();
        String[] commands = new String[]{"/bin/sh", "-c", command};
        try {
            Process proc = new ProcessBuilder(commands).start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            while ((s = stdError.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LOG.info("Unix command execution result: " + sb.toString());
        return sb.toString();
    }

    public static Process executeCommandOnUnix(String command) {
        LOG.info("On Unix execute command: [{}]", (Object)command);
        String[] commands = new String[]{"/bin/sh", "-c", command};
        Process proc = null;
        try {
            proc = new ProcessBuilder(commands).start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return proc;
    }

    public static void executeOnWin(String command) throws IOException {
        LOG.info("On Windows execute command: [{}]", (Object)command);
        Runtime.getRuntime().exec("cmd /c " + command);
    }

    public static File assertFileExists(String filePath) {
        LOG.info("Verify file {} exists", (Object)filePath);
        File file = Paths.get(filePath, new String[0]).toFile();
        boolean exists = file.exists();
        for (int retry = 0; !exists && retry < retryCountSeconds - 10; ++retry) {
            Utility.waitToLoopTime(1, new String[0]);
            exists = file.exists();
        }
        Assert.assertTrue((boolean)file.exists(), (String)String.format("File with path %s was not found.", filePath));
        return file;
    }

    public static File assertFileDoesNotExist(String filePath) {
        LOG.info("Verify file {} does not exist", (Object)filePath);
        File file = Paths.get(filePath, new String[0]).toFile();
        boolean exists = file.exists();
        for (int retry = 0; !exists && retry < retryCountSeconds - 10; ++retry) {
            Utility.waitToLoopTime(1, new String[0]);
            exists = file.exists();
        }
        Assert.assertFalse((boolean)file.exists(), (String)String.format("File with path %s was found.", filePath));
        return file;
    }

    public static void deleteFolder(File folder) throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            Utility.executeOnWin(String.format("rmdir /S /Q %s", folder.getPath()));
        } else if (SystemUtils.IS_OS_LINUX) {
            Utility.executeOnUnixNoWait(String.format("sudo rm -rf %s", folder.getPath()));
        }
    }

    public static void killProcessName(String processName) throws IOException {
        LOG.info("Killing application using process name [{}]", (Object)processName);
        if (SystemUtils.IS_OS_WINDOWS) {
            String sys32 = System.getenv("SystemRoot") + "\\system32";
            Runtime.getRuntime().exec(new String[]{sys32 + "\\taskkill", "/F", "/IM", processName});
        } else if (SystemUtils.IS_OS_LINUX) {
            Utility.executeOnUnix("kill `ps ax | grep \"" + processName + "\" | awk '{print $1}'`");
        } else if (SystemUtils.IS_OS_MAC) {
            Utility.executeOnUnix("pkill -f " + processName);
        }
    }

    public static void killProcessExcludingMaven(String processName) throws IOException {
        LOG.info("Killing application using process name [{}]", (Object)processName);
        if (SystemUtils.IS_OS_WINDOWS) {
            String sys32 = System.getenv("SystemRoot") + "\\system32";
            Runtime.getRuntime().exec(new String[]{sys32 + "\\taskkill", "/F", "/IM", processName});
        } else {
            Utility.executeOnUnix("sudo kill `ps ax | grep \"" + processName + "\" | grep -v \"mvn\" | grep -v \"maven\" | awk '{print $1}'`");
        }
    }

    public static File setNewFile(FileModel fileModel) {
        File newFile = new File(fileModel.getName());
        try {
            newFile.createNewFile();
            if (!StringUtils.isEmpty((CharSequence)fileModel.getContent())) {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile), Charset.forName("UTF-8").newEncoder());
                writer.write(fileModel.getContent());
                writer.flush();
                writer.close();
            }
        }
        catch (IOException e) {
            LOG.error(String.format("Failed to load file %s", fileModel.getName()));
        }
        newFile.deleteOnExit();
        return newFile;
    }

    public static boolean isProcessRunning(String processName) {
        processName = processName.toLowerCase();
        LOG.info("process name :" + processName);
        Process p = null;
        try {
            String line;
            if (SystemUtils.IS_OS_LINUX) {
                LOG.info("Executing command to check process is running: ps -ef | grep -v \"maven\" | grep -v \"mvn\"");
                p = Utility.executeCommandOnUnix("ps -ef | grep -v \"maven\" | grep -v \"mvn\"");
            } else if (SystemUtils.IS_OS_WINDOWS) {
                String sys32 = System.getenv("SystemRoot") + "\\system32";
                p = Runtime.getRuntime().exec(new String[]{"cmd", "/c", sys32 + "\\tasklist"});
            } else if (SystemUtils.IS_OS_MAC) {
                String com = "pgrep -f " + processName;
                p = Runtime.getRuntime().exec(com);
                InputStream inputStream = p.getInputStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferReader = new BufferedReader(inputStreamReader);
                return bufferReader.readLine() != null;
            }
            InputStream inputStream = p.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferReader = new BufferedReader(inputStreamReader);
            while ((line = bufferReader.readLine()) != null) {
                if (!line.toLowerCase().contains(processName)) continue;
                return true;
            }
            inputStream.close();
            inputStreamReader.close();
            bufferReader.close();
        }
        catch (Exception err) {
            err.printStackTrace();
        }
        return false;
    }

    public static File getMountedApp(File fromLocation) throws TestConfigurationException {
        File[] filesInMountedDrive = fromLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".app");
            }
        });
        if (filesInMountedDrive == null) {
            throw new TestConfigurationException("It seems there is not mounted App on location: " + fromLocation.getPath());
        }
        if (filesInMountedDrive.length > 0) {
            LOG.info("Found executable binary:  [{}] ", (Object)filesInMountedDrive[0].getPath());
            return filesInMountedDrive[0];
        }
        return null;
    }

    public static String getTextFromClipboard() throws IOException, UnsupportedFlavorException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        return (String)clipboard.getData(DataFlavor.stringFlavor);
    }

    public static String executeOnWinAndReturnOutput(String command) {
        LOG.info("On Windows execute command: [{}]", (Object)command);
        StringBuilder sb = new StringBuilder();
        try {
            Process executionProcess = Runtime.getRuntime().exec("cmd /c " + command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(executionProcess.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(executionProcess.getErrorStream()));
            String s = null;
            while ((s = stdInput.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            while ((s = stdError.readLine()) != null) {
                sb.append(s);
                sb.append("\n");
            }
            stdInput.close();
            stdError.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static void assertIsEmpty(File folder) {
        if (folder.exists()) {
            File[] list;
            for (File item : list = folder.listFiles()) {
                LOG.info(String.format("Found file/folder: %s", item.getPath()));
            }
            Assert.assertEquals((long)FileUtils.sizeOf((File)folder), (long)0L, (String)"Size of install folder(bytes): ");
        }
    }

    public static boolean waitUntilProcessIsRunning(String processName) {
        boolean isRunning = false;
        Utility.waitToLoopTime(1, "Wait until process is running...");
        for (int retry = 0; !isRunning && retry <= 2 * retryCountSeconds; ++retry) {
            Utility.waitToLoopTime(1, "Wait until process is running...");
            isRunning = Utility.isProcessRunning(processName);
        }
        return isRunning;
    }

    public static void waitUntilProcessFinishes(String processName, int timeout, int loopTime) {
        for (int count = 0; Utility.isProcessRunning(processName) && count < timeout; count += loopTime) {
            Utility.waitToLoopTime(loopTime, "Wait until process finishes...");
        }
    }

    public static String getOSName() throws IOException {
        String osVersion = SystemUtils.OS_NAME;
        if (SystemUtils.IS_OS_LINUX) {
            String output = Utility.executeOnUnix("cat /etc/*-release");
            Properties osProperties = new Properties();
            osProperties.load(new StringReader(output));
            osVersion = osProperties.getProperty("NAME");
            osVersion = osVersion.split(" ")[0];
        }
        return osVersion.replaceAll(" ", "_").replaceAll("\"", "");
    }

    public static boolean isWinServiceRunning(String serviceName) throws IOException {
        String line;
        String sys32 = System.getenv("SystemRoot") + "\\system32";
        Process process = new ProcessBuilder(Paths.get(sys32, "sc.exe").toString(), "query", serviceName).start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        Object scOutput = "";
        while ((line = br.readLine()) != null) {
            scOutput = (String)scOutput + line + "\n";
        }
        if (((String)scOutput).contains("STATE")) {
            return ((String)scOutput).contains("RUNNING");
        }
        throw new RuntimeException("Unknown Service: " + serviceName);
    }
}

