/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import com.google.common.io.Files;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import org.alfresco.dataprep.AlfrescoHttpClient;
import org.alfresco.dataprep.AlfrescoHttpClientFactory;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.dsl.DSL;
import org.alfresco.utility.dsl.DSLJmx;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.FileModel;
import org.alfresco.utility.model.FolderModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.network.JmxBuilder;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.testng.Assert;

public abstract class TestData<Data>
implements DSL<Data> {
    static Logger LOG = LogFactory.getLogger();
    protected UserModel currentUser;
    private String currentSpace = "/";
    private String currentSite = "";
    private String lastResource = "";
    private String lastNodeId = "";
    @Autowired
    protected TasProperties tasProperties;
    @Autowired
    private AlfrescoHttpClientFactory alfrescoHttpClientFactory;
    public static String PASSWORD = "password";
    public static String EMAIL = "%s@tas-automation.org";
    private String serverLogUrl;
    private String logResponse;
    @Autowired
    private JmxBuilder jmxBuilder;

    public static boolean isAFile(String filename) {
        return Files.getFileExtension((String)filename).length() == 3;
    }

    @Override
    public Data usingUser(UserModel user) {
        this.currentUser = user;
        return (Data)this;
    }

    @Override
    public Data usingAdmin() {
        this.currentUser = this.getAdminUser();
        return (Data)this;
    }

    public UserModel getAdminUser() {
        return new UserModel(this.tasProperties.getAdminUser(), this.tasProperties.getAdminPassword());
    }

    @Override
    public UserModel getCurrentUser() {
        if (this.currentUser == null) {
            this.usingAdmin();
        }
        return this.currentUser;
    }

    @Override
    public Data usingRoot() {
        this.setCurrentSpace("");
        return (Data)this;
    }

    @Override
    public String getCurrentSpace() {
        return this.currentSpace;
    }

    @Override
    public Data setCurrentSpace(String currentRepositorySpace) {
        this.currentSpace = currentRepositorySpace;
        return (Data)this;
    }

    @Override
    public Data usingResource(ContentModel model) {
        if (model.getCmisLocation().equals(model.getName())) {
            String location = "";
            if (model instanceof FolderModel) {
                location = Utility.buildPath(this.getLastResource(), model.getName());
            } else if (model instanceof FileModel) {
                FileModel fileModel = (FileModel)model;
                location = FilenameUtils.getExtension((String)model.getName()).length() == 0 ? Utility.buildPath(this.getLastResource(), String.format("%s.%s", model.getName(), fileModel.getFileType().extension)) : Utility.buildPath(this.getLastResource(), model.getName());
            }
            location = Utility.removeLastSlash(location);
            model.setCmisLocation(location);
        }
        this.setLastResource(model.getCmisLocation());
        this.setCurrentSpace(model.getCmisLocation());
        this.setLastNodeId(model.getNodeRefWithoutVersion());
        return (Data)this;
    }

    @Override
    public Data usingSite(String siteId) {
        this.setCurrentSpace(String.format(this.getSitesPath(), siteId));
        this.setCurrentSite(siteId);
        this.setLastResource(this.getCurrentSpace());
        this.setLastNodeId(this.getSiteDocLibNodeId(siteId));
        return (Data)this;
    }

    @Override
    public Data usingSite(SiteModel siteModel) {
        Utility.checkObjectIsInitialized(siteModel, "siteModel");
        return this.usingSite(siteModel.getId());
    }

    @Override
    public Data usingUserHome(String username) {
        this.setCurrentSpace(String.format(this.getUserHomesPath(), username));
        return (Data)this;
    }

    @Override
    public Data usingUserHome() {
        this.setCurrentSpace(String.format(this.getUserHomesPath(), this.getCurrentUser().getUsername()));
        return (Data)this;
    }

    @Override
    public String getRootPath() throws TestConfigurationException {
        return "";
    }

    @Override
    public String getSitesPath() throws TestConfigurationException {
        return "/Sites/%s/documentLibrary";
    }

    @Override
    public String getUserHomesPath() throws TestConfigurationException {
        return "/User Homes/%s";
    }

    @Override
    public String getDataDictionaryPath() throws TestConfigurationException {
        return "/Data Dictionary";
    }

    public String getLastNodeId() {
        return this.lastNodeId;
    }

    public void setLastNodeId(String lastNodeId) {
        this.lastNodeId = lastNodeId;
    }

    public String getCurrentSite() {
        return this.currentSite;
    }

    public void setCurrentSite(String currentSite) {
        this.currentSite = currentSite;
    }

    public String getLastResource() {
        return this.lastResource;
    }

    public Data setLastResource(String lastResource) {
        this.lastResource = lastResource;
        return (Data)this;
    }

    public void setCurrentUser(UserModel testUser) {
        this.currentUser = testUser;
    }

    public Data usingLastServerLogLines(int lineNumber) throws Exception {
        this.assertExtensionAmpExists("alfresco-log-extension");
        this.serverLogUrl = this.tasProperties.getFullServerUrl() + "/alfresco/s/tas/log";
        String baseDir = this.getAlfrescoHome();
        String logFile = (String)this.jmxBuilder.getJmxClient().readProperty("log4j:appender=File", "file");
        Step.STEP(String.format("Log API: jmx log4j:appender=File", logFile));
        String logPath = logFile.contains(baseDir) ? logFile : Utility.buildPath(baseDir, logFile);
        Step.STEP(String.format("Log API: log path is %s", logPath));
        HashMap<String, String> paramsServerlog = new HashMap<String, String>();
        paramsServerlog.put("path", logPath);
        paramsServerlog.put("lineNumber", "" + lineNumber);
        this.serverLogUrl = Utility.toUrlParams(this.serverLogUrl, paramsServerlog);
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(this.serverLogUrl);
        String unhashedString = String.format("%s:%s", this.tasProperties.getAdminUser(), this.tasProperties.getAdminPassword());
        get.setRequestHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])unhashedString.getBytes()));
        get.getParams().setSoTimeout(5000);
        client.executeMethod((HttpMethod)get);
        this.logResponse = IOUtils.toString((InputStream)get.getResponseBodyAsStream(), (String)"UTF-8");
        return (Data)this;
    }

    public Data assertLogLineIs(String logLine) {
        Step.STEP(String.format("Log API: Assert that log file contains %s", logLine));
        Assert.assertTrue((boolean)this.logResponse.contains(logLine), (String)String.format("Log file doesn't contain %s. Found %s", logLine, this.logResponse));
        return (Data)this;
    }

    public void assertExtensionAmpExists(String moduleId) throws Exception {
        boolean findModule = false;
        if (this.tasProperties.useJolokiaJmxAgent()) {
            String allInstaledModules = (String)this.jmxBuilder.getJmxClient().readProperty("Alfresco:Name=ModuleService", "AllModules");
            JSONArray modules = new JSONArray(allInstaledModules);
            for (int i = 0; i < modules.length(); ++i) {
                if (!modules.getJSONObject(i).get("module.id").toString().equals(moduleId) || !modules.getJSONObject(i).get("module.installState").toString().equals("INSTALLED")) continue;
                findModule = true;
                break;
            }
        } else {
            CompositeData[] allInstaledModules;
            for (CompositeData compData : allInstaledModules = (CompositeData[])this.jmxBuilder.getJmxClient().readProperty("Alfresco:Name=ModuleService", "AllModules")) {
                if (!compData.containsKey("module.id") || !compData.get("module.id").equals(moduleId)) continue;
                findModule = true;
                break;
            }
        }
        Assert.assertEquals((boolean)findModule, (boolean)true, (String)("Alfresco AMP module :" + moduleId + " is not installed"));
    }

    public String getAlfrescoHome() throws Exception {
        String alfrescoHome = (String)this.jmxBuilder.getJmxClient().readProperty("Alfresco:Name=SystemProperties", "alfresco.home");
        Step.STEP(String.format("Log API: jmx alfresco.home" + alfrescoHome, new Object[0]));
        return alfrescoHome;
    }

    public DSLJmx withJMX() {
        return new DSLJmx(this.jmxBuilder.getJmxClient());
    }

    private String getSiteDocLibNodeId(String siteId) {
        AlfrescoHttpClient client = this.alfrescoHttpClientFactory.getObject();
        String reqUrl = client.getApiVersionUrl() + "sites/" + siteId + "/containers/documentLibrary";
        HttpGet get = new HttpGet(reqUrl);
        HttpResponse response = client.execute(this.tasProperties.getAdminUser(), this.tasProperties.getAdminPassword(), (HttpRequestBase)get);
        if (200 == response.getStatusLine().getStatusCode()) {
            JSONObject jsonObject = new JSONObject((Map)client.readStream(response.getEntity()));
            return jsonObject.getJSONObject("entry").getString("id");
        }
        throw new RuntimeException("Could not set Doclib nodeId. Request response: " + client.getParameterFromJSON(response, "briefSummary", new String[]{"error"}));
    }
}

