/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.Assert;
import org.springframework.web.util.UriComponentsBuilder;

class AISClient {
    private final String clientId;
    private final String adminUsername;
    private final String adminPassword;
    private final URI tokenUri;
    private final URI usersUri;
    private final HttpClient httpClient;
    private static final Gson GSON = new Gson();

    AISClient(String clientId, String adminUsername, String adminPassword, URI tokenUri, URI usersUri, HttpClient httpClient) {
        this.clientId = Objects.requireNonNull(clientId);
        this.adminUsername = Objects.requireNonNull(adminUsername);
        this.adminPassword = Objects.requireNonNull(adminPassword);
        this.tokenUri = Objects.requireNonNull(tokenUri);
        this.usersUri = Objects.requireNonNull(usersUri);
        this.httpClient = Objects.requireNonNull(httpClient);
    }

    Map<String, ?> authorizeUser(String username, String password) {
        HttpRequest request = this.createFormPostRequest(this.tokenUri, Map.of("grant_type", "password", "username", username, "password", password, "client_id", this.clientId));
        String response = this.getResponse(request, this.requireOkStatus(r -> String.format("Failed to obtain AIS User (%s) Access Token: %s", username, r.body())));
        return (Map)GSON.fromJson(response, Map.class);
    }

    List<Map<String, Object>> findUser(String username) {
        URI uri = UriComponentsBuilder.fromUri((URI)this.usersUri).queryParam("username", new Object[]{username}).queryParam("first", new Object[]{0}).queryParam("max", new Object[]{Integer.MAX_VALUE}).build().toUri();
        HttpRequest request = this.authenticatedRequestBuilder(uri).GET().build();
        String response = this.getResponse(request, this.requireOkStatus(r -> "Failed to search for users: " + String.valueOf(r.body())));
        return (List)GSON.fromJson(response, List.class);
    }

    void createUser(String username, String password, String firstName, String lastName, String email) {
        HttpRequest request = this.authenticatedRequestBuilder(this.usersUri).header("Content-Type", "application/json;charset=UTF-8").POST(AISClient.asJson(Map.of("username", username, "email", email, "firstName", firstName, "lastName", lastName, "enabled", true, "credentials", List.of(Map.of("type", "password", "value", password, "temporary", false))))).build();
        this.getResponse(request, this.requireCreatedStatus(r -> "Failed to create AIS user: " + String.valueOf(r.body())));
    }

    void deleteUser(String userId) {
        URI uri = UriComponentsBuilder.fromUri((URI)this.usersUri).pathSegment(new String[]{userId}).build().toUri();
        HttpRequest request = this.authenticatedRequestBuilder(uri).DELETE().build();
        this.getResponse(request, this.requireNoContentStatus(r -> "Failed to delete AIS user: " + String.valueOf(r.body())));
    }

    void updateUser(Map<String, Object> user) {
        URI uri = UriComponentsBuilder.fromUri((URI)this.usersUri).pathSegment(new String[]{AISClient.extractUserId(user)}).build().toUri();
        HttpRequest request = this.authenticatedRequestBuilder(uri).header("Content-Type", "application/json;charset=UTF-8").PUT(AISClient.asJson(user)).build();
        this.getResponse(request, this.requireNoContentStatus(r -> "Failed to save AIS user: " + String.valueOf(r.body())));
    }

    private HttpRequest.Builder authenticatedRequestBuilder(URI uri) {
        String accessToken = this.getAdminAccessToken();
        return HttpRequest.newBuilder(uri).header("Authorization", "Bearer " + accessToken).header("Accept", "application/json");
    }

    private String getAdminAccessToken() {
        Map<String, ?> authorization = this.authorizeUser(this.adminUsername, this.adminPassword);
        return (String)authorization.get("access_token");
    }

    private Consumer<HttpResponse<?>> requireNoContentStatus(Function<HttpResponse<?>, String> message) {
        return this.requireStatus(204, message);
    }

    private Consumer<HttpResponse<?>> requireCreatedStatus(Function<HttpResponse<?>, String> message) {
        return this.requireStatus(201, message);
    }

    private Consumer<HttpResponse<?>> requireOkStatus(Function<HttpResponse<?>, String> message) {
        return this.requireStatus(200, message);
    }

    private Consumer<HttpResponse<?>> requireStatus(int expectedStatus, Function<HttpResponse<?>, String> message) {
        return r -> Assert.assertEquals((String)((String)message.apply((HttpResponse<?>)r)), (long)expectedStatus, (long)r.statusCode());
    }

    private String getResponse(HttpRequest request, Consumer<HttpResponse<?>> ... responseValidators) {
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            Stream.of(responseValidators).forEach(v -> v.accept(response));
            return response.body();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    private HttpRequest createFormPostRequest(URI uri, Map<String, String> formParams) {
        String encodedForm = formParams.entrySet().stream().map(e -> (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        return HttpRequest.newBuilder().uri(uri).headers("Content-Type", "application/x-www-form-urlencoded").header("Accept", "application/json").POST(HttpRequest.BodyPublishers.ofString(encodedForm)).build();
    }

    static void setEnabled(Map<String, Object> user, boolean isEnabled) {
        user.put("enabled", isEnabled);
    }

    static String extractUserId(Map<String, ?> user) {
        return Optional.ofNullable(user).map(u -> u.get("id")).filter(String.class::isInstance).map(String.class::cast).orElse(null);
    }

    private static HttpRequest.BodyPublisher asJson(Map<String, ?> map) {
        return HttpRequest.BodyPublishers.ofString(GSON.toJson(map));
    }
}

