/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.net.URI;
import java.net.http.HttpClient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.utility.TasAisProperties;
import org.alfresco.utility.data.AisToken;
import org.alfresco.utility.data.auth.AISClient;
import org.alfresco.utility.data.auth.UserManageable;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Scope(value="prototype")
public class DataAIS
implements InitializingBean {
    private static final Log LOG = LogFactory.getLog(DataAIS.class);
    private static final HashMap<Integer, AisToken> aisTokens = new HashMap();
    private static final int TIMEOUT_DELTA_MILLISECONDS = 5000;
    private boolean enabled;
    @Autowired
    private TasAisProperties aisProperties;
    private AISClient aisClient;

    public void afterPropertiesSet() {
        String authServerUrl = this.aisProperties.getAuthServerUrl();
        if (authServerUrl != null && !authServerUrl.isEmpty()) {
            this.enabled = true;
        }
        if (this.enabled) {
            String realm = this.aisProperties.getRealm();
            String resource = this.aisProperties.getResource();
            String adminUsername = this.aisProperties.getAdminUsername();
            String adminPassword = this.aisProperties.getAdminPassword();
            Assert.assertTrue((String)"AIS realm can not be empty", (realm != null && !realm.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"AIS resource can not be empty", (resource != null && !resource.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"AIS adminUsername can not be empty", (adminUsername != null && !adminUsername.isEmpty() ? 1 : 0) != 0);
            Assert.assertTrue((String)"AIS adminPassword can not be empty", (adminPassword != null && !adminPassword.isEmpty() ? 1 : 0) != 0);
            LOG.info((Object)String.format("[AlfrescoIdentityService] Building AIS clients. Url= %s ", authServerUrl));
            URI issuerUri = UriComponentsBuilder.fromUriString((String)authServerUrl).pathSegment(new String[]{"realms", realm}).build().toUri();
            URI tokenUri = UriComponentsBuilder.fromUri((URI)issuerUri).pathSegment(new String[]{"protocol", "openid-connect", "token"}).build().toUri();
            URI usersUri = UriComponentsBuilder.fromUriString((String)authServerUrl).pathSegment(new String[]{"admin", "realms", realm, "users"}).build().toUri();
            HttpClient httpClient = HttpClient.newHttpClient();
            this.aisClient = new AISClient(resource, adminUsername, adminPassword, tokenUri, usersUri, httpClient);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Builder perform() {
        Assert.assertTrue((String)"[AlfrescoIdentityService] AlfrescoIdentityService support is disabled.", (boolean)this.isEnabled());
        return new Builder();
    }

    public class Builder
    implements UserManageable {
        private Builder() {
        }

        @Override
        public Builder createUser(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Add user %s", user.getUsername()));
            DataAIS.this.aisClient.createUser(user.getUsername(), user.getPassword(), user.getFirstName(), user.getLastName(), user.getEmailAddress());
            return this;
        }

        @Override
        public Builder deleteUser(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Delete user %s", user.getUsername()));
            String userId = AISClient.extractUserId(this.findUserByUsername(user.getUsername()));
            if (userId != null) {
                this.removeTokenForUser(this.generateTokenKey(user));
                DataAIS.this.aisClient.deleteUser(userId);
            }
            return this;
        }

        @Override
        public Builder updateUser(UserModel user, HashMap<String, String> attributes) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        @Override
        public Builder assertUserExists(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Assert user %s exists", user.getUsername()));
            Assert.assertNotNull(this.findUserByUsername(user.getUsername()));
            return this;
        }

        @Override
        public Builder assertUserDoesNotExist(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Assert user %s does not exists", user.getUsername()));
            Assert.assertNull(this.findUserByUsername(user.getUsername()));
            return this;
        }

        public Builder disableUser(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Disable user %s", user.getUsername()));
            Map<String, Object> userRepresentation = this.findUserByUsername(user.getUsername());
            AISClient.setEnabled(userRepresentation, false);
            DataAIS.this.aisClient.updateUser(userRepresentation);
            this.removeTokenForUser(this.generateTokenKey(user));
            return this;
        }

        public Builder enableUser(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Enable user %s", user.getUsername()));
            Map<String, Object> userRepresentation = this.findUserByUsername(user.getUsername());
            AISClient.setEnabled(userRepresentation, true);
            DataAIS.this.aisClient.updateUser(userRepresentation);
            return this;
        }

        private Map<String, ?> obtainAccessToken(UserModel user) {
            LOG.info((Object)String.format("[AlfrescoIdentityService] Obtain access token for user %s", user.getUsername()));
            return DataAIS.this.aisClient.authorizeUser(user.getUsername(), user.getPassword());
        }

        private Map<String, Object> findUserByUsername(String username) {
            List<Map<String, Object>> matchingUsers = DataAIS.this.aisClient.findUser(username);
            if (matchingUsers.size() == 1) {
                return matchingUsers.get(0);
            }
            if (matchingUsers.size() > 1) {
                for (Map<String, Object> user : matchingUsers) {
                    if (!username.equalsIgnoreCase((String)user.get("username"))) continue;
                    return user;
                }
            }
            return null;
        }

        public synchronized void addTokenForUser(Integer key, Map<String, ?> tokenResponse) {
            long currentTime = System.currentTimeMillis();
            AisToken token = new AisToken((String)tokenResponse.get("access_token"), (String)tokenResponse.get("refresh_token"), currentTime, ((Number)tokenResponse.get("expires_in")).longValue() * 1000L);
            aisTokens.put(key, token);
        }

        public synchronized void removeTokenForUser(Integer key) {
            aisTokens.remove(key);
        }

        public Boolean checkTokenValidity(Integer key) {
            long currentTime = System.currentTimeMillis();
            if (aisTokens.containsKey(key)) {
                AisToken token = aisTokens.get(key);
                return currentTime < token.getExpirationTime() - 5000L;
            }
            return false;
        }

        public AisToken getAccessToken(UserModel user) {
            Integer key = this.generateTokenKey(user);
            if (!this.checkTokenValidity(key).booleanValue()) {
                Map<String, ?> tokenResponse = this.obtainAccessToken(user);
                this.addTokenForUser(key, tokenResponse);
            }
            return aisTokens.get(key);
        }

        private Integer generateTokenKey(UserModel user) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (user.getUsername() == null ? 0 : user.getUsername().hashCode());
            result = 31 * result + (user.getPassword() == null ? 0 : user.getPassword().hashCode());
            return result;
        }
    }
}

