/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.dsl;

import java.io.IOException;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.ResourceContent;
import org.alfresco.utility.dsl.DSL;
import org.alfresco.utility.dsl.DSLAssertion;
import org.alfresco.utility.dsl.DSLWrapper;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.network.JmxClient;
import org.alfresco.utility.report.log.Step;

public abstract class DSLProtocol<Client>
extends DSLWrapper<Client>
implements DSL<Client> {
    private String currentSpace = null;
    private ResourceContent lastResource = new ResourceContent(this);
    private ContentModel lastContentModel = new ContentModel();

    @Override
    public Client usingUser(UserModel user) throws Exception {
        this.setTestUser(user);
        return (Client)this;
    }

    @Override
    public Client usingAdmin() throws Exception {
        this.setTestUser(this.dataContent.getAdminUser());
        return (Client)this;
    }

    @Override
    public UserModel getCurrentUser() {
        return this.getTestUser();
    }

    @Override
    public Client usingRoot() throws Exception {
        this.setCurrentSpace(this.getRootPath());
        return (Client)this;
    }

    protected String buildSiteDocumentLibraryPath(String siteId, String ... filesOrFoldersHierarcy) throws TestConfigurationException {
        String root = String.format("%s/%s/%s", this.getSitesPath(), siteId, "documentLibrary");
        return Utility.buildPath(root, filesOrFoldersHierarcy);
    }

    protected String buildUserHomePath(String username, String ... filesOrFoldersHierarcy) throws TestConfigurationException {
        String root = String.format("%s/%s", this.getUserHomesPath(), username);
        return Utility.buildPath(root, filesOrFoldersHierarcy);
    }

    @Override
    public String getCurrentSpace() throws TestConfigurationException {
        if (this.currentSpace == null) {
            this.currentSpace = this.getRootPath();
        }
        return this.currentSpace;
    }

    @Override
    public Client setCurrentSpace(String currentRepositorySpace) {
        this.currentSpace = currentRepositorySpace;
        this.setLastResource(currentRepositorySpace);
        return (Client)this;
    }

    public Client closeJmxConnection() throws IOException {
        if (this.jmxBuilder.getJmxClient() instanceof JmxClient) {
            JmxClient jmx = (JmxClient)this.jmxBuilder.getJmxClient();
            jmx.closeConnection();
        }
        return (Client)this;
    }

    protected abstract String getProtocolJMXConfigurationStatus() throws Exception;

    public boolean isProtocolEnabled() throws Exception {
        this.LOG.info("Check [{}] protocol is enabled via JMX", (Object)this.getProtocolName());
        String status = this.getProtocolJMXConfigurationStatus();
        return status.equals("true");
    }

    public String getLastResource() {
        return this.lastResource.getFullPath();
    }

    public String getLastResourceWithoutPrefix() {
        return this.lastResource.getPathWithoutPrefix();
    }

    public void setLastResource(String fullPath) {
        this.lastResource.setFullPath(fullPath);
    }

    public String getProtocolName() {
        return this.getClass().getSimpleName().replaceAll("Wrapper", "");
    }

    public Client and() {
        return (Client)this;
    }

    public Client then() {
        return (Client)this;
    }

    public Client when() {
        return (Client)this;
    }

    public abstract Client authenticateUser(UserModel var1) throws Exception;

    public abstract Client disconnect() throws Exception;

    @Override
    public abstract Client usingSite(SiteModel var1) throws Exception;

    @Override
    public abstract Client usingSite(String var1) throws Exception;

    @Override
    public abstract Client usingUserHome(String var1) throws Exception;

    @Override
    public abstract Client usingUserHome() throws Exception;

    @Override
    public abstract String getRootPath() throws TestConfigurationException;

    @Override
    public abstract String getSitesPath() throws TestConfigurationException;

    @Override
    public abstract String getUserHomesPath() throws TestConfigurationException;

    @Override
    public abstract String getDataDictionaryPath() throws TestConfigurationException;

    public abstract String getPrefixSpace();

    @Override
    public abstract Client usingResource(ContentModel var1) throws Exception;

    public DSLAssertion assertThat() {
        return new DSLAssertion(this);
    }

    public Client waitSeconds(int seconds) {
        Step.STEP(String.format("UTILITY: Waiting for %s seconds", seconds));
        Utility.waitToLoopTime(seconds, new String[0]);
        return (Client)this;
    }

    public String buildPath(String parent, String ... paths) {
        return Utility.convertBackslashToSlash(Utility.buildPath(parent, paths)).replace("//", "/");
    }

    public ContentModel getLastContentModel() {
        return this.lastContentModel;
    }

    public void setLastContentModel(ContentModel lastContentModel) {
        this.lastContentModel = lastContentModel;
    }
}

