/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.listener.XmlTestsSuiteWriter;
import org.slf4j.Logger;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.internal.TestNGMethod;

public class SanityTestsGeneratorListener
implements ISuiteListener {
    private static Logger LOG = LogFactory.getLogger();

    public void onStart(ISuite suite) {
        List<String> projects = this.resolveTestGroups(suite);
        String xmlFileName = this.resolveXMLFileName(suite);
        List testsOnRuntime = suite.getAllMethods();
        LOG.info("Total number of tests: " + testsOnRuntime.size());
        Map groupsOfTests = suite.getMethodsByGroups();
        HashMap<String, List<String>> testClasses = new HashMap<String, List<String>>();
        for (String key : projects) {
            if (!groupsOfTests.keySet().contains(key)) continue;
            LOG.info("Total number of tests for TestGroup = '" + key + "' is " + ((Collection)groupsOfTests.get(key)).size());
            for (TestNGMethod test : (Collection)groupsOfTests.get(key)) {
                String className = test.getConstructorOrMethod().getMethod().getDeclaringClass().getName();
                if (testClasses.containsKey(className)) {
                    ((List)testClasses.get(className)).add(test.getMethodName());
                    continue;
                }
                ArrayList<String> methods = new ArrayList<String>();
                methods.add(test.getMethodName());
                testClasses.put(className, methods);
            }
        }
        XmlTestsSuiteWriter writer = new XmlTestsSuiteWriter();
        writer.generateXmlFile(this.fullPath(xmlFileName), testClasses, projects.get(0));
        System.exit(0);
    }

    private List<String> resolveTestGroups(ISuite suite) {
        String[] parameters;
        ArrayList<String> groups = new ArrayList<String>();
        String testGroup = suite.getParameter("testGroup");
        if (testGroup == null) {
            groups.add("sanity");
            return groups;
        }
        for (String group : parameters = testGroup.split(",")) {
            groups.add(group.trim());
        }
        return groups;
    }

    private String resolveXMLFileName(ISuite suite) {
        String testGroup = suite.getParameter("xmlFileName");
        if (testGroup == null) {
            return "tas-sanity-suite.xml";
        }
        return testGroup;
    }

    private String fullPath(String xmlFileName) {
        return "src/main/resources/" + xmlFileName;
    }

    public void onFinish(ISuite suite) {
    }
}

