/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.listener;

import java.io.File;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.alfresco.utility.LogFactory;
import org.slf4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlTestsSuiteWriter {
    public static Logger LOG = LogFactory.getLogger();
    private static final String SUITE_NAME = "Tests for Test Group = ";

    public void generateXmlFile(String xmlFileName, Map<String, List<String>> testClasses, String testGroup) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            doc.setXmlStandalone(true);
            this.generateXMLBody(doc, testClasses, testGroup);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-system", "http://testng.org/testng-1.0.dtd");
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(xmlFileName));
            transformer.transform(source, result);
        }
        catch (Exception e) {
            LOG.error("Cannot create the xml file log. Error: {}", (Object)e.getMessage());
        }
    }

    private void generateXMLBody(Document doc, Map<String, List<String>> testClasses, String testGroup) {
        Element rootElement = doc.createElement("suite");
        doc.appendChild(rootElement);
        Attr suiteName = doc.createAttribute("name");
        suiteName.setValue(SUITE_NAME + testGroup);
        rootElement.setAttributeNode(suiteName);
        Attr verboseAttr = doc.createAttribute("verbose");
        verboseAttr.setValue("1");
        rootElement.setAttributeNode(verboseAttr);
        Element testElement = doc.createElement("test");
        rootElement.appendChild(testElement);
        Attr testNameAttr = doc.createAttribute("name");
        testNameAttr.setValue("Tas sanity suite");
        testElement.setAttributeNode(testNameAttr);
        Element classesElement = doc.createElement("classes");
        testElement.appendChild(classesElement);
        for (String className : testClasses.keySet()) {
            Element classElement = doc.createElement("class");
            classesElement.appendChild(classElement);
            Attr classNameAttr = doc.createAttribute("name");
            classNameAttr.setValue(className);
            classElement.setAttributeNode(classNameAttr);
            Element methodsElement = doc.createElement("methods");
            classElement.appendChild(methodsElement);
            for (String methodName : testClasses.get(className)) {
                Element includeElement = doc.createElement("include");
                methodsElement.appendChild(includeElement);
                Attr includeName = doc.createAttribute("name");
                includeName.setValue(methodName);
                includeElement.setAttributeNode(includeName);
            }
        }
    }
}

