/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.concurrent.TimeUnit;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.DataValue;
import org.alfresco.utility.model.UserModel;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.testng.Assert;

public abstract class NetworkDrive {
    static Logger LOG = LogFactory.getLogger();
    private String serverNetworkPath;
    private String localVolumePath;
    private UserModel userForNetworkAccess = new UserModel(DataValue.UNDEFINED.toString(), DataValue.UNDEFINED.toString());

    public NetworkDrive(UserModel userModel, String serverNetworkPath, String localVolumePath) {
        this.setUserForNetworkAccess(userModel);
        this.setLocalVolumePath(localVolumePath);
        this.setServerNetworkPath(serverNetworkPath);
    }

    protected abstract void mountCode() throws Exception;

    protected abstract void umountCode() throws Exception;

    public void mount() throws Exception {
        LOG.info("Mounting {} using User {} to drive {} ", new Object[]{this.getServerNetworkPath(), this.getUserForNetworkAccess().toString(), this.getLocalVolumePath()});
        this.mountCode();
        this.assertNetworkDriveIsMounted();
    }

    public void unount() throws Exception {
        LOG.info("UnMounting drive {} using User {}", (Object)this.getLocalVolumePath(), (Object)this.getUserForNetworkAccess().toString());
        this.umountCode();
    }

    public UserModel getUserForNetworkAccess() {
        return this.userForNetworkAccess;
    }

    public void setUserForNetworkAccess(UserModel userModel) {
        this.userForNetworkAccess = userModel;
    }

    protected void runCommand(String command, Object ... arguments) throws Exception {
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            Utility.executeOnUnix(String.format(command, arguments));
        } else {
            Utility.executeOnWin(String.format(command, arguments));
        }
    }

    public String getLocalVolumePath() {
        return this.localVolumePath;
    }

    public void setLocalVolumePath(String localVolumePath) {
        this.localVolumePath = localVolumePath;
    }

    public String getServerNetworkPath() {
        return this.serverNetworkPath;
    }

    public void setServerNetworkPath(String serverNetworkPath) {
        this.serverNetworkPath = serverNetworkPath;
    }

    public boolean isNetworkDriveMounted() throws Exception {
        File mountedDrive = Paths.get(this.getLocalVolumePath(), new String[0]).toFile();
        for (long counter = 0L; counter < 20L && !mountedDrive.exists(); ++counter) {
            TimeUnit.MILLISECONDS.sleep(200L);
        }
        LOG.info("Verify network mounted drive : {}, Mounted: {} ", (Object)this.getLocalVolumePath(), (Object)mountedDrive.exists());
        return mountedDrive.exists();
    }

    public void assertNetworkDriveIsMounted() throws Exception {
        Assert.assertTrue((boolean)this.isNetworkDriveMounted(), (String)String.format("Network Drive [{}] was mounted successfully", this.getLocalVolumePath()));
    }

    public void assertNetworkDriveIsUmounted() throws Exception {
        Assert.assertFalse((boolean)this.isNetworkDriveMounted(), (String)String.format("Network Drive [{}] was umounted successfully", this.getLocalVolumePath()));
    }

    public File createFile(String relativePathToLocalVolumePath) throws IOException {
        File newFile = Paths.get(this.getLocalVolumePath(), relativePathToLocalVolumePath).toFile();
        LOG.info("Create a new file {}, in mapped network drive", (Object)newFile.getPath());
        newFile.createNewFile();
        return newFile;
    }

    public File createFile(String relativePathToLocalVolumePath, FileInputStream fileInputStream) throws IOException {
        File newFile = Paths.get(this.getLocalVolumePath(), relativePathToLocalVolumePath).toFile();
        LOG.info("Create a new file {}, in mapped network drive", (Object)newFile.getPath());
        newFile.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(newFile);
        IOUtils.copy((InputStream)fileInputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return newFile;
    }

    public File createFolder(String relativePathToLocalVolumePath) throws IOException {
        File newFolder = Paths.get(this.getLocalVolumePath(), relativePathToLocalVolumePath).toFile();
        LOG.info("Create a new folder {}, in mapped network drive", (Object)newFolder.getPath());
        newFolder.mkdir();
        return newFolder;
    }

    public void deleteContent(String relativePathToLocalVolumePath) throws IOException {
        File newFile = Paths.get(this.getLocalVolumePath(), relativePathToLocalVolumePath).toFile();
        LOG.info("Delete content {} from mapped network drive", (Object)newFile.getPath());
        newFile.delete();
    }

    public File updateContent(String relativePathToLocalVolumePath, ByteArrayInputStream byteArrayInputStream) throws IOException {
        File newFile = Paths.get(this.getLocalVolumePath(), relativePathToLocalVolumePath).toFile();
        FileOutputStream fileOutputStream = new FileOutputStream(newFile);
        IOUtils.copy((InputStream)byteArrayInputStream, (OutputStream)fileOutputStream);
        fileOutputStream.close();
        return newFile;
    }

    public File renameContent(String originalRelativePath, String renamedRelativePath) throws IOException {
        File originalFile = Paths.get(this.getLocalVolumePath(), originalRelativePath).toFile();
        File renamedFile = Paths.get(this.getLocalVolumePath(), renamedRelativePath).toFile();
        LOG.info("Rename content {} as {}, in mapped network drive", (Object)originalFile.getPath(), (Object)renamedFile.getPath());
        originalFile.renameTo(renamedFile);
        return renamedFile;
    }

    public File copyFile(String sourceRelativePath, String destinationRelativePath) throws IOException {
        File sourceContent = Paths.get(this.getLocalVolumePath(), sourceRelativePath).toFile();
        File destinationContent = Paths.get(this.getLocalVolumePath(), destinationRelativePath).toFile();
        LOG.info("Copy file {} to {}, in mapped network drive", (Object)sourceContent.getPath(), (Object)destinationContent.getPath());
        FileUtils.copyFile((File)sourceContent, (File)destinationContent);
        return destinationContent;
    }

    public File copyFolder(String sourceRelativePath, String destinationRelativePath) throws IOException {
        File sourceContent = Paths.get(this.getLocalVolumePath(), sourceRelativePath).toFile();
        File destinationContent = Paths.get(this.getLocalVolumePath(), destinationRelativePath).toFile();
        LOG.info("Copy folder {} to {}, in mapped network drive", (Object)sourceContent.getPath(), (Object)destinationContent.getPath());
        FileUtils.copyDirectory((File)sourceContent, (File)destinationContent);
        return destinationContent;
    }

    public File moveFile(String sourceRelativePath, String destinationRelativePath) throws IOException {
        File sourceContent = Paths.get(this.getLocalVolumePath(), sourceRelativePath).toFile();
        File destinationContent = Paths.get(this.getLocalVolumePath(), destinationRelativePath).toFile();
        LOG.info("Move file from {} to {}, in mapped network drive", (Object)sourceContent.getPath(), (Object)destinationContent.getPath());
        FileUtils.moveFile((File)sourceContent, (File)destinationContent);
        return destinationContent;
    }

    public File moveFolder(String sourceRelativePath, String destinationRelativePath) throws IOException {
        File sourceContent = Paths.get(this.getLocalVolumePath(), sourceRelativePath).toFile();
        File destinationContent = Paths.get(this.getLocalVolumePath(), destinationRelativePath).toFile();
        LOG.info("Move folder from {} to {}, in mapped network drive", (Object)sourceContent.getPath(), (Object)destinationContent.getPath());
        FileUtils.moveDirectory((File)sourceContent, (File)destinationContent);
        return destinationContent;
    }
}

