/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report;

import com.relevantcodes.extentreports.ExtentReports;
import com.relevantcodes.extentreports.ExtentTest;
import com.relevantcodes.extentreports.LogStatus;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.ReportManager;
import org.alfresco.utility.web.AbstractWebTest;
import org.slf4j.Logger;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.xml.XmlSuite;

public class HtmlReportListener
implements IReporter {
    static Logger LOG = LogFactory.getLogger();
    static Properties log4jProperties;
    static Properties defaultProperties;
    private ExtentReports extent = null;

    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String outputDirectory) {
        try {
            log4jProperties = Utility.getProperties(HtmlReportListener.class, "log4j.properties");
            defaultProperties = Utility.getProperties(HtmlReportListener.class, Utility.getEnvironmentPropertyFile());
            this.extent = ReportManager.getReporter();
        }
        catch (URISyntaxException | TestConfigurationException e1) {
            LOG.error("Could not initialize HTML Report: " + e1.getMessage());
            return;
        }
        for (ISuite suite : suites) {
            Map result = suite.getResults();
            for (ISuiteResult r : result.values()) {
                ITestContext context = r.getTestContext();
                this.buildTestNodes(context.getFailedConfigurations(), LogStatus.FATAL);
                this.buildTestNodes(context.getPassedTests(), LogStatus.PASS);
                this.buildTestNodes(context.getFailedTests(), LogStatus.FAIL);
                this.buildTestNodes(context.getSkippedTests(), LogStatus.SKIP);
            }
        }
        if (defaultProperties.getProperty("testManagement.enabled").equals("true")) {
            String contentTestRail = this.getLogsContent(this.getLogsLocation("log4j.appender.testrailLog.File", log4jProperties));
            this.extent.setTestRunnerOutput(String.format("<pre>%s </pre>", contentTestRail));
        }
        String content = this.getLogsContent(this.getLogsLocation("log4j.appender.file.File", log4jProperties));
        this.extent.setTestRunnerOutput(String.format("<pre>%s </pre>", content));
        try {
            this.extent.flush();
            this.extent.close();
        }
        catch (Exception e) {
            LOG.error("Something happened on closing the report: {}", (Object)e.getMessage());
        }
    }

    private String trackerUrl(String issueID) {
        return String.format("<a href=\"https://alfresco.atlassian.net/browse/%s\" target=\"_blank\">%s</a>", issueID, issueID);
    }

    private void buildTestNodes(IResultMap tests, LogStatus status) {
        if (this.extent == null) {
            return;
        }
        if (tests.size() > 0) {
            for (ITestResult result : tests.getAllResults()) {
                ExtentTest test;
                Bug bugAnnotated = result.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Bug.class);
                String testName = "";
                Object[] objs = result.getParameters();
                testName = objs.length > 0 ? objs[0].toString() : result.getMethod().getMethodName();
                if (bugAnnotated != null) {
                    test = this.extent.startTest(String.format("%s # %s (BUG: %s)", result.getInstance().getClass().getSimpleName(), testName, this.trackerUrl(bugAnnotated.id())));
                    if (bugAnnotated.status().equals((Object)Bug.Status.OPENED)) {
                        test.assignCategory(new String[]{"BUGS"});
                        if (bugAnnotated.description().isEmpty() && status != LogStatus.SKIP) {
                            test.log(status, String.format("This test is failing due to this issue %s", this.trackerUrl(bugAnnotated.id())));
                        } else if (!bugAnnotated.description().isEmpty() && status != LogStatus.SKIP) {
                            test.log(status, String.format("This test is failing due to this issue %s. <b>Description:</b> %s", this.trackerUrl(bugAnnotated.id()), bugAnnotated.description()));
                        }
                        if (status == LogStatus.PASS) {
                            test.log(status, String.format("Currently, test with opened bug %s is passed. Please check if this issue is passed and update the @Bug status to FIXED.", this.trackerUrl(bugAnnotated.id())));
                        }
                    } else if (status == LogStatus.PASS) {
                        test.assignCategory(new String[]{"FIXED-BUGS"});
                        test.log(status, String.format("Currently, test passed. But it failed in a regression due to this issue %s", this.trackerUrl(bugAnnotated.id())));
                    }
                } else {
                    test = this.extent.startTest(String.format("%s # %s", result.getTestClass().getRealClass().getSimpleName(), testName));
                    test.assignCategory(new String[]{"WITHOUT-BUGS"});
                }
                if (status == LogStatus.SKIP && result.getTestContext().getFailedConfigurations().size() > 0) {
                    test.log(status, "Test is skipped due to a configuration test method like a @BeforeClass method. Filter the tests by 'FATAL' error to analyze the root cause.");
                }
                test.setStartedTime(this.getTime(result.getStartMillis()));
                test.setEndedTime(this.getTime(result.getEndMillis()));
                for (String group : result.getMethod().getGroups()) {
                    test.assignCategory(new String[]{group});
                }
                if (result.getThrowable() != null) {
                    if (result.getInstance() instanceof AbstractWebTest) {
                        String screenshotsDir = defaultProperties.getProperty("screenshots.dir");
                        String screenshotsPath = Paths.get(defaultProperties.getProperty("reports.path"), screenshotsDir).toString();
                        File screenshot = Paths.get(screenshotsPath, testName + ".png").toFile();
                        if (screenshot.exists()) {
                            test.log(status, String.format("Screenshot below: %s", test.addScreenCapture(Paths.get(screenshotsDir, testName + ".png").toFile().getPath())));
                        }
                    }
                    test.log(status, result.getThrowable());
                } else {
                    test.log(status, "Test " + status.toString().toLowerCase() + "ed");
                }
                this.extent.endTest(test);
            }
        }
    }

    private Date getTime(long millis) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar.getTime();
    }

    private String getLogsContent(String filePath) {
        String content = "";
        try {
            List<Object> lines = new ArrayList();
            BufferedReader reader = null;
            reader = Files.newBufferedReader(Paths.get(filePath, new String[0]), StandardCharsets.ISO_8859_1);
            lines = reader.lines().collect(Collectors.toList());
            content = String.join((CharSequence)"\n", lines);
        }
        catch (IOException e) {
            LOG.error(String.format("Cannot read log file due tos: %s", e.getMessage()));
        }
        return content;
    }

    private String getLogsLocation(String key, Properties properties) {
        String log4jPath = ".";
        Properties log4jProperties = new Properties();
        try {
            log4jProperties = Utility.getProperties(this.getClass(), "log4j.properties");
            log4jPath = log4jProperties.getProperty(key);
        }
        catch (TestConfigurationException e1) {
            LOG.error("Cannot read '{}' key from log4j.properties file. Error: {}", (Object)key, (Object)e1.getMessage());
        }
        return log4jPath;
    }
}

