/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web;

import java.lang.reflect.Method;
import java.util.Set;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.web.HtmlPage;
import org.alfresco.utility.web.browser.WebBrowser;
import org.alfresco.utility.web.browser.WebBrowserFactory;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;

public abstract class AbstractWebTest
extends AbstractTestNGSpringContextTests {
    @Autowired
    WebBrowserFactory browserFactory;
    protected static final ThreadLocal<WebBrowser> browserThread = new ThreadLocal();
    protected Logger LOG = LogFactory.getLogger();

    @BeforeSuite(alwaysRun=true)
    public void initializeBeans() throws Exception {
        super.springTestContextPrepareTestInstance();
    }

    @BeforeClass(alwaysRun=true)
    public void defineBrowser() throws Exception {
        browserThread.set(this.browserFactory.getWebBrowser());
        this.initializeBrowser();
    }

    @AfterClass(alwaysRun=true)
    public void closeBrowser() {
        this.LOG.info("Closing WebDrone!");
        if (AbstractWebTest.getBrowser() != null) {
            AbstractWebTest.getBrowser().quit();
        }
    }

    @BeforeMethod(alwaysRun=true)
    public void startTest(Method method) throws Exception {
        this.LOG.info("***************************************************************************************************");
        DateTime now = new DateTime();
        this.LOG.info("*** {} ***  Starting test {}:{} ", new Object[]{now.toString("HH:mm:ss"), method.getDeclaringClass().getSimpleName(), method.getName()});
        this.LOG.info("***************************************************************************************************");
    }

    @AfterMethod(alwaysRun=true)
    public void endTest(Method method, ITestResult result) throws Exception {
        this.LOG.info("***************************************************************************************************");
        DateTime now = new DateTime();
        this.LOG.info("*** {} ***   Ending test {}:{} {} ({} s.)", new Object[]{now.toString("HH:mm:ss"), method.getDeclaringClass().getSimpleName(), method.getName(), result.isSuccess() ? "SUCCESS" : "!!! FAILURE !!!", (result.getEndMillis() - result.getStartMillis()) / 1000L});
        this.LOG.info("***************************************************************************************************");
    }

    public static WebBrowser getBrowser() {
        return browserThread.get();
    }

    private void initializeBrowser() throws ClassNotFoundException {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(((Object)((Object)this)).getClass()));
        Set components = provider.findCandidateComponents(this.getPageObjectRootPackage());
        for (BeanDefinition component : components) {
            Class<?> pageObject = Class.forName(component.getBeanClassName());
            if (!pageObject.getClass().isInstance(HtmlPage.class)) continue;
            try {
                Object bean = this.applicationContext.getBean(pageObject);
                if (!(bean instanceof HtmlPage)) continue;
                HtmlPage page = (HtmlPage)bean;
                page.setBrowser(AbstractWebTest.getBrowser());
            }
            catch (NoSuchBeanDefinitionException e) {}
        }
    }

    public abstract String getPageObjectRootPackage();
}

