/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventWebBrowserListener
implements WebDriverListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventWebBrowserListener.class);
    private String oldValue;

    public void beforeClick(WebElement element) {
        LOG.debug("Trying to click '{}'", (Object)this.getElementName(element));
    }

    public void afterClick(WebElement element) {
        LOG.info("Clicked on element '{}'", (Object)this.getElementName(element));
    }

    public void afterFindElement(WebDriver driver, By by, WebElement element) {
        LOG.debug("'{}' - found", (Object)by);
    }

    public void afterBack(WebDriver.Navigation navigation) {
        LOG.info("Navigated Back");
    }

    public void afterForward(WebDriver.Navigation driver) {
        LOG.info("Navigated Forward");
    }

    public void afterGet(WebDriver driver, String url) {
        LOG.info("Navigate to '{}'", (Object)url);
    }

    public void afterExecuteScript(WebDriver driver, String script, Object[] args, Object result) {
        LOG.info("Ran script '{}'", (Object)script);
    }

    public void onError(Object target, Method method, Object[] args, InvocationTargetException e) {
        Throwable cause = e.getCause();
        String targetName = target != null ? target.getClass().getSimpleName() : "Unknown target";
        String methodName = method != null ? method.getName() : "Unknown method";
        LOG.error("Error occurred in [{}] while calling method [{}] with args {}", new Object[]{targetName, methodName, cause});
    }

    private String getElementName(WebElement element) {
        int arrowIndex;
        String foundBy = element.toString();
        if (foundBy != null && (arrowIndex = foundBy.indexOf("->")) >= 0) {
            return "By." + foundBy.substring(arrowIndex + 3, foundBy.length() - 1);
        }
        return "unknown";
    }

    public void beforeRefresh(WebDriver.Navigation navigation) {
    }

    public void afterRefresh(WebDriver.Navigation navigation) {
    }

    public void afterAccept(Alert alert) {
    }

    public void afterDismiss(Alert alert) {
    }

    public void beforeAccept(Alert alert) {
    }

    public void beforeDismiss(Alert alert) {
    }
}

