/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.utility.web.HtmlPage;
import org.alfresco.utility.web.browser.WebBrowser;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import org.springframework.beans.factory.annotation.Autowired;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementDecorator;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;

public abstract class WebDriverAware {
    protected WebBrowser browser;

    public WebBrowser getBrowser() {
        return this.browser;
    }

    public void setBrowser(WebBrowser webBrowser) {
        if (webBrowser.equals(this.browser)) {
            return;
        }
        this.browser = webBrowser;
        PageFactory.initElements((FieldDecorator)new HtmlElementDecorator((CustomElementLocatorFactory)new HtmlElementLocatorFactory((SearchContext)webBrowser.getDriver())), (Object)this);
        List<Field> allFields = this.getAllDeclaredFields(new LinkedList<Field>(), this.getClass());
        for (Field field : allFields) {
            for (Autowired annotation : (Autowired[])field.getAnnotationsByType(Autowired.class)) {
                try {
                    if (!field.getClass().isInstance(HtmlPage.class)) continue;
                    field.setAccessible(true);
                    HtmlPage page = (HtmlPage)field.get(this);
                    page.setBrowser(this.browser);
                    field.set(this, page);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected List<Field> getAllDeclaredFields(List<Field> fields, Class<?> type) {
        if (type.isAssignableFrom(HtmlPage.class)) {
            return fields;
        }
        fields.addAll(Arrays.asList(type.getDeclaredFields()));
        if (type.getSuperclass() != null) {
            fields = this.getAllDeclaredFields(fields, type.getSuperclass());
        }
        return fields;
    }
}

