/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.alfresco.dataprep.UserService;
import org.alfresco.utility.constants.UserRole;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.exception.DataPreparationException;
import org.alfresco.utility.model.ContentModel;
import org.alfresco.utility.model.SiteModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.apache.commons.httpclient.HttpState;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataUser
extends TestData<DataUser> {
    @Autowired
    private UserService userService;
    static String USER_NOT_CREATED = "User %s  not created";

    public UserModel createUser(String userName) throws DataPreparationException {
        return this.createUser(userName, PASSWORD);
    }

    public UserModel createUser(UserModel user) throws DataPreparationException {
        return this.createUser(user.getUsername(), user.getPassword());
    }

    public UserModel createUser(String userName, String password) throws DataPreparationException {
        UserModel newUser = new UserModel(userName, password);
        Step.STEP(String.format("DATAPREP: Creating %s user", newUser.getUsername()));
        LOG.info("Create user {}", (Object)newUser.toString());
        newUser.setFirstName(String.format("FN-%s", userName));
        newUser.setLastName(String.format("LN-%s", userName));
        Boolean created = this.userService.create(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), userName, password, String.format(EMAIL, userName), newUser.getFirstName(), newUser.getLastName());
        if (!created.booleanValue()) {
            throw new DataPreparationException(String.format(USER_NOT_CREATED, newUser.toString()));
        }
        newUser.setDomain(this.getCurrentUser().getDomain());
        return newUser;
    }

    public UserModel createUserWithCustomEmailAddressInAlfresco(String userName, String password, String domain) throws DataPreparationException {
        UserModel newUser = new UserModel(userName, password);
        Step.STEP(String.format("DATAPREP: Creating %s user", newUser.getUsername()));
        LOG.info("Create user {}", (Object)newUser.toString());
        Boolean created = this.userService.create(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), userName, password, String.format("%s@%s", userName, domain), String.format("%s FirstName", userName), String.format("LN-%s", userName));
        if (!created.booleanValue()) {
            throw new DataPreparationException(String.format(USER_NOT_CREATED, newUser.toString()));
        }
        return newUser;
    }

    public UserModel createUserWithTenant(String userName) throws DataPreparationException {
        UserModel newUser = new UserModel(userName, PASSWORD);
        newUser.setDomain(this.getCurrentUser().getDomain());
        Step.STEP(String.format("DATAPREP: Creating %s tenant user", newUser.getUsername()));
        Boolean created = this.userService.create(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userName, PASSWORD, String.format(EMAIL, userName), String.format("%s FirstName", userName), String.format("LN-%s", userName));
        if (!created.booleanValue()) {
            throw new DataPreparationException(String.format(USER_NOT_CREATED, newUser.toString()));
        }
        return newUser;
    }

    public UserModel createRandomTestUser() throws DataPreparationException {
        String user = RandomData.getRandomName("User");
        return this.createUser(user);
    }

    public UserModel createRandomTestUser(String prefix) throws DataPreparationException {
        String user = RandomData.getRandomName(prefix);
        return this.createUser(user);
    }

    public void addUserToSite(UserModel userModel, SiteModel siteModel, UserRole role) {
        Step.STEP(String.format("DATAPREP: Adding [%s] user with role [%s] role to [%s] site", userModel.getUsername(), role.toString(), siteModel.getId()));
        this.userService.createSiteMember(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userModel.getUsername(), siteModel.getId(), role.toString());
        userModel.setUserRole(role);
    }

    public void removeUserFromSite(UserModel userModel, SiteModel siteModel) {
        Step.STEP(String.format("DATAPREP: Removing user [%s] from site [%s]", userModel.getUsername(), siteModel.getId()));
        this.userService.removeSiteMembership(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userModel.getUsername(), siteModel.getId());
    }

    public ListUserWithRoles addUsersWithRolesToSite(SiteModel siteModel, UserRole ... roles) throws DataPreparationException {
        ListUserWithRoles usersWithRoles = new ListUserWithRoles();
        for (UserRole role : roles) {
            UserModel userModel = this.createRandomTestUser();
            this.addUserToSite(userModel, siteModel, role);
            usersWithRoles.add(userModel);
        }
        return usersWithRoles;
    }

    public void assertUserExist(UserModel user) {
        this.assertUserExist(user.getUsername());
    }

    public void assertUserExist(String username) {
        Step.STEP(String.format("DATAPREP: Assert that %s user exists", username));
        LOG.info("Check user {} exist in repository", (Object)username.toString());
        Assert.assertTrue((boolean)this.isUserInRepo(username), (String)String.format("User {} exist in repository", username));
    }

    public void assertUserDoesNotExist(UserModel user) {
        Step.STEP(String.format("DATAPREP: Assert that %s user does not exist ", user.getUsername()));
        LOG.info("Check user {} does not exist in repository", (Object)user.toString());
        Assert.assertFalse((boolean)this.isUserInRepo(user.getUsername()), (String)String.format("User {} exist in repository", user.toString()));
    }

    public boolean isUserInRepo(String username) {
        return this.userService.userExists(this.tasProperties.getAdminUser(), this.tasProperties.getAdminPassword(), username);
    }

    public void deleteUser(UserModel userToDelete) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Deleting %s user", userToDelete.getUsername()));
        LOG.info("Delete user {}", (Object)userToDelete.getUsername());
        boolean deleted = this.userService.delete(this.getAdminUser().getUsername(), this.getAdminUser().getPassword(), userToDelete.getUsername());
        if (!deleted) {
            throw new DataPreparationException(String.format("Failed to delete user '%s'.", userToDelete.getUsername()));
        }
    }

    public void disableUser(UserModel userToDisable) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Disable %s user", userToDisable.getUsername()));
        boolean disabled = this.userService.disableUser(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userToDisable.getUsername(), true);
        if (!disabled) {
            throw new DataPreparationException(String.format("Failed to disable user '%s'.", userToDisable.getUsername()));
        }
    }

    public void assertTrashCanHasContent(ContentModel ... contents) {
        List nodes = this.userService.getItemsNodeRefFromTrashcan(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword());
        List<Object> matches = new ArrayList();
        for (ContentModel content : contents) {
            matches.clear();
            Step.STEP(String.format("DATAPREP: Verify if %s is in trash can", content.getName()));
            String contentNodeId = content.getNodeRefWithoutVersion().replace("workspace://SpacesStore/", "").replace("archive://SpacesStore/", "");
            matches = nodes.stream().filter(it -> it.contains(contentNodeId)).collect(Collectors.toList());
            Assert.assertFalse((boolean)matches.isEmpty(), (String)String.format("Item %s found in trash can", content.getName()));
        }
    }

    public void assertTrashCanDoesNotHaveContent(ContentModel ... contents) {
        List nodes = this.userService.getItemsNodeRefFromTrashcan(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword());
        List<Object> matches = new ArrayList();
        for (ContentModel content : contents) {
            matches.clear();
            Step.STEP(String.format("DATAPREP: Verify if %s is not in trash can", content.getName()));
            String contentNodeId = content.getNodeRefWithoutVersion().replace("workspace://SpacesStore/", "").replace("archive://SpacesStore/", "");
            matches = nodes.stream().filter(it -> it.contains(contentNodeId)).collect(Collectors.toList());
            Assert.assertTrue((boolean)matches.isEmpty(), (String)String.format("Item %s found in trash can", content.getName()));
        }
    }

    public void setUserQuota(UserModel userToModify, int quota) throws DataPreparationException {
        Step.STEP(String.format("DATAPREP: Set %d MB quota to %s user", quota, userToModify.getUsername()));
        boolean status = this.userService.setUserQuota(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userToModify.getUsername(), quota);
        if (!status) {
            throw new DataPreparationException(String.format("Failed to set quota to user '%s'.", userToModify.getUsername()));
        }
    }

    public void assertUserIsAuthorized(UserModel userToVerify) {
        Step.STEP(String.format("DATAPREP: Verify that user %s is authorized", userToVerify.getUsername()));
        Assert.assertTrue((boolean)this.userService.isUserAuthorized(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userToVerify.getUsername()));
    }

    public void assertUserIsNotAuthorized(UserModel userToVerify) {
        Step.STEP(String.format("DATAPREP: Verify that user %s is not authorized", userToVerify.getUsername()));
        Assert.assertFalse((boolean)this.userService.isUserAuthorized(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), userToVerify.getUsername()));
    }

    public HttpState login(UserModel testUser) {
        Step.STEP(String.format("DATAPREP: Login with %s/%s", testUser.getUsername(), testUser.getPassword()));
        return this.userService.login(testUser.getUsername(), testUser.getPassword());
    }

    public void logout() {
        Step.STEP(String.format("DATAPREP: Logout %s", this.getCurrentUser().getUsername()));
        this.userService.logout();
    }

    public class ListUserWithRoles {
        private List<UserModel> usersWithRoles = new ArrayList<UserModel>();

        public void add(UserModel userModel) {
            this.usersWithRoles.add(userModel);
        }

        public UserModel getOneUserWithRole(UserRole userRole) {
            UserModel userModel = null;
            for (UserModel user : this.usersWithRoles) {
                if (!user.getUserRole().equals((Object)userRole)) continue;
                return user;
            }
            return userModel;
        }
    }
}

