/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.dataprep.WorkflowService;
import org.alfresco.utility.data.DataUser;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.ProcessModel;
import org.alfresco.utility.model.TaskModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataWorkflow
extends TestData<DataWorkflow> {
    @Autowired
    WorkflowService workflowService;

    public TaskModel createNewTaskAndAssignTo(UserModel userModel) {
        return this.createNewTask(new TaskModel(userModel.getUsername()));
    }

    public TaskModel createTaskWithProcessDefAndAssignTo(String processDefId, UserModel userModel) {
        return this.createTaskWithProcessDefId(new TaskModel(userModel.getUsername()), processDefId);
    }

    public TaskModel createNewTask(TaskModel taskModel) {
        Step.STEP(String.format("DATAPREP: User %s creates new task %s and assigns it to user %s", this.getCurrentUser().getUsername(), taskModel.getMessage(), taskModel.getAssignee()));
        String workflowId = this.workflowService.startNewTask(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), taskModel.getMessage(), taskModel.getDueDate(), taskModel.getAssignee(), taskModel.getPriority(), this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), taskModel.getSendEmail().booleanValue());
        taskModel.setProcessId(workflowId);
        if (taskModel.getAssignee().equals(this.getAdminUser().getUsername())) {
            taskModel.setId(this.workflowService.getTaskId(taskModel.getAssignee(), this.getAdminUser().getPassword(), workflowId));
        } else {
            taskModel.setId(this.workflowService.getTaskId(taskModel.getAssignee(), DataUser.PASSWORD, workflowId));
        }
        return taskModel;
    }

    public TaskModel createTaskWithProcessDefId(TaskModel taskModel, String processDefId) {
        Step.STEP(String.format("DATAPREP: User %s creates new task %s with and assigns it to user %s", this.getCurrentUser().getUsername(), taskModel.getMessage(), taskModel.getAssignee()));
        String processId = this.workflowService.startProcessWithDefinitionId(processDefId, this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), taskModel.getMessage(), taskModel.getDueDate(), taskModel.getAssignee(), taskModel.getPriority(), this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), taskModel.getSendEmail().booleanValue());
        taskModel.setProcessId(processId);
        if (taskModel.getAssignee().equals(this.getAdminUser().getUsername())) {
            taskModel.setId(this.workflowService.getTaskId(taskModel.getAssignee(), this.getAdminUser().getPassword(), processId));
        } else {
            taskModel.setId(this.workflowService.getTaskId(taskModel.getAssignee(), this.getCurrentUser().getPassword(), processId));
        }
        return taskModel;
    }

    public TaskModel createPooledReviewTaskAndAssignTo(GroupModel groupModel) {
        TaskModel taskModel = new TaskModel(groupModel.getDisplayName());
        Step.STEP(String.format("DATAPREP: User %s creates new task %s and assigns it to group %s", this.getCurrentUser().getUsername(), taskModel.getMessage(), taskModel.getAssignee()));
        String workflowId = this.workflowService.startPooledReview(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), taskModel.getMessage(), taskModel.getDueDate(), taskModel.getAssignee(), taskModel.getPriority(), this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), taskModel.getSendEmail().booleanValue());
        taskModel.setProcessId(workflowId);
        taskModel.setId(this.workflowService.getTaskId(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), workflowId));
        return taskModel;
    }

    public TaskModel claimTask(TaskModel taskModel) {
        Step.STEP(String.format("DATAPREP: User %s claims task %s", this.getCurrentUser().getUsername(), taskModel.getMessage()));
        this.workflowService.claimTask(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), taskModel.getProcessId());
        return taskModel;
    }

    public ProcessModel createMoreReviewersWorkflowAndAssignTo(UserModel ... users) {
        Step.STEP(String.format("DATAPREP: User %s creates 'One or More Reviewers' workflow/process", this.getCurrentUser().getUsername()));
        ProcessModel process = new ProcessModel();
        ArrayList<String> reviewers = new ArrayList<String>();
        for (UserModel user : users) {
            reviewers.add(user.getUsername());
        }
        DateTime today = new DateTime();
        String workflowId = this.workflowService.startMultipleReviewers(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), RandomData.getRandomAlphanumeric(), today.plusDays(2).toDate(), reviewers, CMISUtil.Priority.High, this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), 0, true);
        process.setId(workflowId);
        for (UserModel user : users) {
            TaskModel task = new TaskModel();
            task.setId(this.workflowService.getTaskId(user.getUsername(), user.getPassword(), workflowId));
            task.setAssignee(user.getUsername());
            process.addTaskToList(task);
        }
        return process;
    }

    public ProcessModel createGroupReviewTaskAndAssignTo(GroupModel groupModel) {
        ProcessModel process = new ProcessModel();
        Step.STEP(String.format("DATAPREP: User %s creates new 'group review' workflow and assigns it to group %s", this.getCurrentUser().getUsername(), groupModel.getDisplayName()));
        DateTime today = new DateTime();
        String workflowId = this.workflowService.startGroupReview(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), RandomData.getRandomAlphanumeric(), today.plusDays(2).toDate(), groupModel.getDisplayName(), CMISUtil.Priority.High, this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), 0, true);
        process.setId(workflowId);
        return process;
    }

    public ProcessModel createSingleReviewerTaskAndAssignTo(UserModel userModel) {
        ProcessModel process = new ProcessModel();
        Step.STEP(String.format("DATAPREP: User %s creates new 'single reviewer' workflow and assigns it to user %s", this.getCurrentUser().getUsername(), userModel.getUsername()));
        DateTime today = new DateTime();
        String workflowId = this.workflowService.startSingleReview(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), RandomData.getRandomAlphanumeric(), today.plusDays(2).toDate(), userModel.getUsername(), CMISUtil.Priority.High, this.getCurrentSite(), Arrays.asList(new File(this.getLastResource()).getName()), true);
        process.setId(workflowId);
        return process;
    }

    public ProcessModel approveTask(ProcessModel processModel) {
        Step.STEP(String.format("DATAPREP: User %s approves task %s", this.getCurrentUser().getUsername(), processModel.getId()));
        this.workflowService.approveTask(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), processModel.getId(), true, WorkflowService.TaskStatus.COMPLETED, "");
        return processModel;
    }

    public TaskModel taskDone(TaskModel taskModel) {
        Step.STEP(String.format("DATAPREP: User %s completes task %s", this.getCurrentUser().getUsername(), taskModel.getId()));
        this.workflowService.taskDone(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), taskModel.getProcessId(), WorkflowService.TaskStatus.COMPLETED, "complete task");
        return taskModel;
    }

    public boolean deleteProcess(ProcessModel processModel) {
        Step.STEP(String.format("DATAPREP: User %s - delete process %s", this.getCurrentUser().getUsername(), processModel.getId()));
        return this.workflowService.deleteWorkflow(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), processModel.getId());
    }

    public boolean cancelProcess(ProcessModel processModel) {
        Step.STEP(String.format("DATAPREP: User %s - cancel process %s", this.getCurrentUser().getUsername(), processModel.getId()));
        return this.workflowService.cancelWorkflow(this.getCurrentUser().getUsername(), this.getCurrentUser().getPassword(), processModel.getId());
    }
}

