/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.data.auth.GroupManageable;
import org.alfresco.utility.data.auth.UserManageable;
import org.alfresco.utility.exception.TestStepException;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataLDAP {
    @Autowired
    private TasProperties tasProperties;
    private DirContext context;

    public Builder perform() throws NamingException {
        return new Builder();
    }

    public Builder performLdap2() throws NamingException {
        return new Builder(this.tasProperties.getLdap2URL(), this.tasProperties.getLdap2SecurityPrincipal(), this.tasProperties.getLdap2SecurityCredentials(), this.tasProperties.getLdapSearchBase2());
    }

    public class Builder
    implements UserManageable,
    GroupManageable {
        private String searchBase = "";

        public Builder() throws NamingException {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", DataLDAP.this.tasProperties.getAuthContextFactory());
            properties.put("java.naming.provider.url", DataLDAP.this.tasProperties.getLdapURL());
            properties.put("java.naming.security.authentication", DataLDAP.this.tasProperties.getSecurityAuth());
            properties.put("java.naming.security.principal", DataLDAP.this.tasProperties.getLdapSecurityPrincipal());
            properties.put("java.naming.security.credentials", DataLDAP.this.tasProperties.getLdapSecurityCredentials());
            this.searchBase = DataLDAP.this.tasProperties.getLdapSearchBase();
            DataLDAP.this.context = new InitialDirContext(properties);
        }

        public Builder(String ldapURL, String ldapSecurityPrincipal, String ldapSecurityCredentials, String ldapSearchBase) throws NamingException {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", DataLDAP.this.tasProperties.getAuthContextFactory());
            properties.put("java.naming.provider.url", ldapURL);
            properties.put("java.naming.security.authentication", DataLDAP.this.tasProperties.getSecurityAuth());
            properties.put("java.naming.security.principal", ldapSecurityPrincipal);
            properties.put("java.naming.security.credentials", ldapSecurityCredentials);
            this.searchBase = ldapSearchBase;
            DataLDAP.this.context = new InitialDirContext(properties);
        }

        @Override
        public Builder createUser(UserModel user) throws NamingException, UnsupportedEncodingException {
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass", ObjectType.user.toString());
            BasicAttribute sn = new BasicAttribute("sn", user.getLastName());
            BasicAttribute fn = new BasicAttribute("givenName", user.getFirstName());
            BasicAttribute samAccountName = new BasicAttribute("samAccountName", user.getUsername());
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            userAccountControl.add(Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.PASSWD_NOTREQD.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue()));
            attributes.put(objectClass);
            attributes.put(sn);
            attributes.put(fn);
            attributes.put(samAccountName);
            attributes.put(userAccountControl);
            DataLDAP.this.context.createSubcontext(String.format(this.searchBase, user.getUsername()), (Attributes)attributes);
            String newQuotedPassword = String.format("\"%s\"", user.getPassword());
            byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("unicodePwd", newUnicodePassword)), new ModificationItem(2, new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.DONT_EXPIRE_PASSWD.getValue())))};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, user.getUsername()), mods);
            return this;
        }

        @Override
        public Builder deleteUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Delete user %s", user.getUsername()));
            DataLDAP.this.context.destroySubcontext(String.format(this.searchBase, user.getUsername()));
            return this;
        }

        @Override
        public Builder updateUser(UserModel user, HashMap<String, String> attributes) throws NamingException, UnsupportedEncodingException {
            Step.STEP(String.format("[LDAP-AD] Update user %s", user.getUsername()));
            ModificationItem[] items = new ModificationItem[attributes.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                BasicAttribute attribute = new BasicAttribute(entry.getKey());
                if (entry.getKey().equals("unicodePwd")) {
                    String newQuotedPassword = String.format("\"%s\"", entry.getValue());
                    byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
                    attribute.add(newUnicodePassword);
                } else {
                    attribute.add(entry.getValue());
                }
                items[i] = new ModificationItem(2, attribute);
                ++i;
            }
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, user.getUsername()), items);
            return this;
        }

        @Override
        public Builder createGroup(GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Create group %s", group.getDisplayName()));
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute samAccountName = new BasicAttribute("samAccountName");
            BasicAttribute name = new BasicAttribute("name");
            objectClass.add(ObjectType.group.toString());
            samAccountName.add(group.getDisplayName());
            name.add(group.getDisplayName());
            attributes.put(objectClass);
            attributes.put(samAccountName);
            attributes.put(name);
            DataLDAP.this.context.createSubcontext(String.format(this.searchBase, group.getDisplayName()), (Attributes)attributes);
            return this;
        }

        @Override
        public Builder deleteGroup(GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Delete group %s", group.getDisplayName()));
            DataLDAP.this.context.destroySubcontext(String.format(this.searchBase, group.getDisplayName()));
            return this;
        }

        @Override
        public Builder addUserToGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Add user %s to group %s", user.getUsername(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("member", String.format(this.searchBase, user.getUsername()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, memberAttribute)};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, group.getDisplayName()), member);
            return this;
        }

        @Override
        public Builder removeUserFromGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Remove user %s from group %s", user.getUsername(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("member", String.format(this.searchBase, user.getUsername()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(3, memberAttribute)};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, group.getDisplayName()), member);
            return this;
        }

        public Builder disableUser(UserModel user) throws NamingException {
            BasicAttribute memberAttribute = new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.ACCOUNTDISABLE.getValue() + UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.PASSWD_NOTREQD.getValue()));
            ModificationItem[] modification = new ModificationItem[]{new ModificationItem(2, memberAttribute)};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, user.getUsername()), modification);
            return this;
        }

        public Builder enableUser(UserModel user) throws NamingException {
            BasicAttribute memberAttribute = new BasicAttribute("userAccountControl", Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.PASSWD_NOTREQD.getValue()));
            ModificationItem[] modification = new ModificationItem[]{new ModificationItem(2, memberAttribute)};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, user.getUsername()), modification);
            return this;
        }

        public SearchResult searchForObjectClass(String name, ObjectType typeOfClass) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(objectClass=%s)", typeOfClass.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataLDAP.this.context.search(String.format(this.searchBase, name), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            if (results.hasMoreElements()) {
                return (SearchResult)results.nextElement();
            }
            return null;
        }

        public Builder createDisabledUser(UserModel user) throws NamingException {
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute sn = new BasicAttribute("sn");
            BasicAttribute samAccountName = new BasicAttribute("samAccountName");
            BasicAttribute userPassword = new BasicAttribute("userPassword");
            BasicAttribute userAccountControl = new BasicAttribute("userAccountControl");
            objectClass.add(ObjectType.user.toString());
            sn.add(user.getLastName());
            samAccountName.add(user.getUsername());
            userPassword.add(user.getPassword());
            userAccountControl.add(Integer.toString(UserAccountStatus.NORMAL_ACCOUNT.getValue() + UserAccountStatus.PASSWORD_EXPIRED.getValue() + UserAccountStatus.ACCOUNTDISABLE.getValue()));
            attributes.put(objectClass);
            attributes.put(sn);
            attributes.put(samAccountName);
            attributes.put(userAccountControl);
            DataLDAP.this.context.createSubcontext(String.format(this.searchBase, user.getUsername()), (Attributes)attributes);
            return this;
        }

        @Override
        public Builder assertUserExists(UserModel user) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert user %s exists", user.getUsername()));
            Assert.assertNotNull((Object)this.searchForObjectClass(user.getUsername(), ObjectType.user));
            return this;
        }

        @Override
        public UserManageable assertUserDoesNotExist(UserModel user) throws NamingException, TestStepException {
            Step.STEP(String.format("[LDAP-AD] Assert user %s does not exist", user.getUsername()));
            Assert.assertNull((Object)this.searchForObjectClass(user.getUsername(), ObjectType.user));
            return this;
        }

        @Override
        public GroupManageable assertGroupExists(GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert group %s exists", group.getDisplayName()));
            Assert.assertNotNull((Object)this.searchForObjectClass(group.getDisplayName(), ObjectType.group));
            return this;
        }

        @Override
        public GroupManageable assertGroupDoesNotExist(GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert group %s does not exist", group.getDisplayName()));
            Assert.assertNull((Object)this.searchForObjectClass(group.getDisplayName(), ObjectType.group));
            return this;
        }

        public Builder assertUserIsDisabled(UserModel user, UserAccountControlValue userAccountControlValue) throws NamingException {
            Attributes accountStatus = DataLDAP.this.context.getAttributes(String.format(this.searchBase, user.getUsername()), new String[]{"userAccountControl"});
            Assert.assertTrue((boolean)accountStatus.toString().contains(userAccountControlValue.toString()), (String)String.format("User account control value expected %s but found %s", userAccountControlValue.toString(), accountStatus.toString()));
            return this;
        }

        public Builder assertUserIsEnabled(UserModel user, UserAccountControlValue userAccountControlValue) throws NamingException {
            Attributes accountStatus = DataLDAP.this.context.getAttributes(String.format(this.searchBase, user.getUsername()), new String[]{"userAccountControl"});
            Assert.assertTrue((boolean)accountStatus.toString().contains(userAccountControlValue.toString()), (String)String.format("User account value expected %s but found %s ", userAccountControlValue.toString(), accountStatus.toString()));
            return this;
        }

        @Override
        public GroupManageable assertUserIsMemberOfGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert user %s is member of group %s", user.getUsername(), group.getDisplayName()));
            Attributes membership = DataLDAP.this.context.getAttributes(String.format(this.searchBase, group.getDisplayName()), new String[]{"member"});
            Assert.assertTrue((boolean)membership.toString().contains(String.format(this.searchBase, user.getUsername())), (String)String.format("User %s is not member of group %s", user.getUsername().toString(), group.getDisplayName().toString()));
            return this;
        }

        @Override
        public GroupManageable assertUserIsNotMemberOfGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert user %s is not member of group %s", user.getUsername(), group.getDisplayName()));
            Attributes membership = DataLDAP.this.context.getAttributes(String.format(this.searchBase, group.getDisplayName()), new String[]{"member"});
            Assert.assertFalse((boolean)membership.toString().contains(String.format(this.searchBase, user.getUsername())), (String)String.format("User %s is member of group %s", user.getUsername().toString(), group.getDisplayName().toString()));
            return this;
        }

        public Builder addBulkUsersInGroups(int noGroups, int noUsersPerGroup) throws NamingException, UnsupportedEncodingException {
            Step.STEP(String.format("[LDAP-AD] Add %s groups with %s users in each group", noGroups, noUsersPerGroup));
            HashMap usersGroupsMap = new HashMap();
            for (int i = 0; i < noGroups; ++i) {
                GroupModel testGroup = GroupModel.getRandomGroupModel();
                this.createGroup(testGroup).assertGroupExists(testGroup);
                ArrayList<UserModel> groupUsers = new ArrayList<UserModel>();
                for (int j = 0; j < noUsersPerGroup; ++j) {
                    UserModel testUser = UserModel.getRandomUserModel();
                    testUser.setPassword("Password1234!");
                    this.createUser(testUser).addUserToGroup(testUser, testGroup);
                    groupUsers.add(testUser);
                }
                usersGroupsMap.put(testGroup, groupUsers);
            }
            return this;
        }

        private SearchResult searchGeneratedData(String partialName, ObjectType typeOfClass) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(&(objectClass=%s)(%s*))", typeOfClass.toString(), partialName);
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataLDAP.this.context.search(this.searchBase.replace("CN=%s,", ""), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            if (results.hasMoreElements()) {
                return (SearchResult)results.nextElement();
            }
            return null;
        }

        public Builder deleteBulkUsers() throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Delete all users which start with 'user-'", new Object[0]));
            SearchResult rez = this.searchGeneratedData("cn=user-", ObjectType.user);
            while (rez != null) {
                DataLDAP.this.context.destroySubcontext(rez.getNameInNamespace());
                rez = this.searchGeneratedData("cn=user-", ObjectType.user);
            }
            return this;
        }

        public Builder deleteBulkGroups() throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Delete all groups which start with 'group-'", new Object[0]));
            SearchResult rez = this.searchGeneratedData("cn=group-", ObjectType.group);
            while (rez != null) {
                DataLDAP.this.context.destroySubcontext(rez.getNameInNamespace());
                rez = this.searchGeneratedData("cn=group-", ObjectType.group);
            }
            return this;
        }

        public Builder addGroupAsMemberOfAnotherGroup(GroupModel childGroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Add group %s as member of group %s", childGroup.getDisplayName(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("memberUID", String.format(this.searchBase, childGroup.getDisplayName()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, memberAttribute)};
            DataLDAP.this.context.modifyAttributes(String.format(this.searchBase, group.getDisplayName()), member);
            return this;
        }

        public Builder assertGroupIsMemberOfGroup(GroupModel childGroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[LDAP-AD] Assert group %s is member of group %s", childGroup.getDisplayName(), group.getDisplayName()));
            Attributes membership = DataLDAP.this.context.getAttributes(String.format(this.searchBase, group.getDisplayName()), new String[]{"memberUid"});
            Assert.assertTrue((boolean)membership.toString().contains(String.format(this.searchBase, childGroup.getDisplayName())));
            return this;
        }

        public String getUserId(UserModel userModel) throws NamingException {
            String[] DCs = this.searchBase.split(",DC=");
            return String.format("%s@%s.%s", userModel.getUsername(), DCs[1], DCs[2]);
        }

        public String getUserDCId(UserModel userModel) throws NamingException {
            return String.format(this.searchBase, userModel.getUsername());
        }
    }

    static enum UserAccountStatus {
        ACCOUNTDISABLE(2),
        NORMAL_ACCOUNT(512),
        PASSWD_NOTREQD(32),
        PASSWORD_EXPIRED(0x800000),
        DONT_EXPIRE_PASSWD(65536);

        private final int value;

        private UserAccountStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum UserAccountControlValue {
        enabled("512"),
        disabled("514"),
        enabledPasswordNotRequired("544"),
        disabledPasswordNotRequired("546");

        private final String userAccountControlValue;

        private UserAccountControlValue(String userAccountControlValue) {
            this.userAccountControlValue = userAccountControlValue;
        }

        public String toString() {
            return this.userAccountControlValue;
        }
    }

    static enum ObjectType {
        user("user"),
        group("group");

        private final String objectType;

        private ObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String toString() {
            return this.objectType;
        }
    }
}

