/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.dsl;

import org.alfresco.utility.data.DataContent;
import org.alfresco.utility.dsl.DSLProtocol;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.report.log.Step;
import org.testng.Assert;

public class DSLAssertion<Protocol> {
    protected DSLProtocol<?> dslProtocol;

    public DSLAssertion(DSLProtocol<?> dslProtocol) {
        this.dslProtocol = dslProtocol;
    }

    public Protocol getProtocol() {
        return (Protocol)this.dslProtocol;
    }

    public Protocol existsInRepo() throws TestConfigurationException {
        Step.STEP(String.format("CMIS: Assert that content '%s' exists in repository", this.dslProtocol.getLastResourceWithoutPrefix()));
        ((DataContent)this.dslProtocol.dataContent.usingUser(this.dslProtocol.getTestUser()).setLastResource(this.dslProtocol.getLastResourceWithoutPrefix())).assertContentExist();
        return (Protocol)this.dslProtocol;
    }

    public Protocol doesNotExistInRepo() throws TestConfigurationException {
        Step.STEP(String.format("CMIS: Assert that content '%s' doesn't exist in repository", this.dslProtocol.getLastResourceWithoutPrefix()));
        ((DataContent)this.dslProtocol.dataContent.usingUser(this.dslProtocol.getTestUser()).setLastResource(this.dslProtocol.getLastResourceWithoutPrefix())).assertContentDoesNotExist();
        return (Protocol)this.dslProtocol;
    }

    public Protocol protocolIsEnabled() throws Exception {
        Assert.assertTrue((boolean)this.dslProtocol.isProtocolEnabled(), (String)String.format("%s protocol is enabled", this.dslProtocol.getProtocolName()));
        return this.getProtocol();
    }

    public Protocol protocolIsDisabled() throws Exception {
        Assert.assertFalse((boolean)this.dslProtocol.isProtocolEnabled(), (String)String.format("%s protocol is disabled", this.dslProtocol.getProtocolName()));
        return this.getProtocol();
    }
}

