/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import java.io.File;
import java.nio.file.Paths;
import javax.xml.bind.annotation.XmlAttribute;
import org.alfresco.utility.Utility;
import org.alfresco.utility.model.RepoTestModel;

public class ContentModel
extends RepoTestModel {
    private String name;
    private String title;
    private String description;
    private String cmisLocation;
    private String protocolLocation;

    public ContentModel() {
    }

    public ContentModel(String name) {
        this.setName(name);
        this.setCmisLocation(name);
    }

    public ContentModel rename(String newName) {
        this.setName(newName);
        this.setCmisLocation(Paths.get(Paths.get(this.getCmisLocation(), new String[0]).getParent().toString(), newName).toString());
        Utility.checkObjectIsInitialized(this.getProtocolLocation(), "getProtocolLocation");
        this.setProtocolLocation(Paths.get(Paths.get(this.getProtocolLocation(), new String[0]).getParent().toString(), newName).toString());
        return this;
    }

    public ContentModel(String name, String title, String description) {
        this(name);
        this.setTitle(title);
        this.setDescription(description);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCmisLocation() {
        return Utility.convertBackslashToSlash(this.cmisLocation);
    }

    public void setCmisLocation(String cmisLocation) {
        this.cmisLocation = cmisLocation;
    }

    public String getProtocolLocation() {
        return this.protocolLocation;
    }

    public void setProtocolLocation(String protocolLocation) {
        this.protocolLocation = protocolLocation;
    }

    public String getParentFolder() {
        return new File(this.getCmisLocation()).getParent();
    }

    public String getProtocolParentFolder() {
        return new File(this.getProtocolLocation()).getParent();
    }

    public static ContentModel my() {
        ContentModel my = new ContentModel();
        my.setName("-my-");
        my.setNodeRef("-my-");
        return my;
    }
}

