/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.network.db.DatabaseOperation;
import org.apache.commons.dbcp.BasicDataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.IncorrectResultSetColumnCountException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.stereotype.Service;

@Service
public class DatabaseOperationImpl
implements DatabaseOperation {
    @Autowired
    protected TasProperties properties;
    private JdbcTemplate jdbcTemplate;

    private DataSource getDataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setUrl(this.properties.getDbUrl());
        String dbUrl = this.properties.getDbUrl();
        if (dbUrl.contains("oracle")) {
            dataSource.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        }
        if (dbUrl.contains("mysql")) {
            dataSource.setDriverClassName("com.mysql.jdbc.Driver");
        }
        if (dbUrl.contains("mariadb")) {
            dataSource.setDriverClassName("org.mariadb.jdbc.Driver");
        }
        if (dbUrl.contains("postgre")) {
            dataSource.setDriverClassName("org.postgresql.Driver");
        }
        if (dbUrl.contains("db2")) {
            dataSource.setDriverClassName("com.ibm.db2.jcc.DB2Driver");
        }
        dataSource.setUsername(this.properties.getDbUsername());
        dataSource.setPassword(this.properties.getDbPassword());
        return dataSource;
    }

    public JdbcTemplate buildJdbcTemplate() {
        if (this.jdbcTemplate == null) {
            this.jdbcTemplate = new JdbcTemplate(this.getDataSource());
        }
        return this.jdbcTemplate;
    }

    @Override
    public boolean disconect() throws SQLException {
        Connection conn = this.buildJdbcTemplate().getDataSource().getConnection();
        if (!conn.isClosed()) {
            conn.close();
        }
        return conn.isClosed();
    }

    @Override
    public String getSatus() {
        return null;
    }

    @Override
    public List<Object> executeQuery(String query) {
        return this.buildJdbcTemplate().query(query, (RowMapper)new TestRowMapper());
    }

    @Override
    public boolean connect() throws SQLException {
        return !this.buildJdbcTemplate().getDataSource().getConnection().isClosed();
    }

    private static class TestRowMapper
    implements RowMapper<Object> {
        private TestRowMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            ResultSetMetaData rsmd = rs.getMetaData();
            int nrOfColumns = rsmd.getColumnCount();
            if (nrOfColumns != 1) {
                throw new IncorrectResultSetColumnCountException(1, nrOfColumns);
            }
            return JdbcUtils.getResultSetValue((ResultSet)rs, (int)1);
        }
    }
}

