/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report;

import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.utility.report.Bug;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.internal.TestNGMethod;

public class TestCountListener
implements ISuiteListener {
    FileWriter fileWriter;
    private static final String COMMA_DELIMITER = ",";
    private static final String NEW_LINE_SEPARATOR = "\n";

    public void onStart(ISuite suite) {
        ArrayList<String> projects = new ArrayList<String>(Arrays.asList("rest-api", "cmis", "ftp", "cifs", "webdav", "aos", "smtp", "imap", "integration", "pre-upgrade", "post-upgrade", "extension-points"));
        List testsOnRuntime = suite.getAllMethods();
        System.out.println("TOTAL NUMBER OF TESTS: " + testsOnRuntime.size());
        int bugAnnotation = 0;
        for (TestNGMethod test : testsOnRuntime) {
            if (((Bug[])test.getConstructorOrMethod().getMethod().getDeclaredAnnotationsByType(Bug.class)).length != 1) continue;
            ++bugAnnotation;
        }
        System.out.println("@Bug TESTS: " + bugAnnotation);
        System.out.println("----------");
        try {
            this.createCVSFile();
        }
        catch (IOException e) {
            System.out.println("Error while creating fileWriter !!!");
            e.printStackTrace();
        }
        Map groupsOfTests = suite.getMethodsByGroups();
        for (String key : projects) {
            if (!groupsOfTests.keySet().contains(key)) continue;
            int sanity = 0;
            int full = 0;
            int core = 0;
            int notAllowed = 0;
            bugAnnotation = 0;
            int bugSanity = 0;
            int bugFull = 0;
            int bugCore = 0;
            System.out.println("----------" + key + "----------");
            System.out.println("TOTAL NUMBER OF TESTS for :  " + key + " - " + ((Collection)groupsOfTests.get(key)).size());
            for (TestNGMethod test : (Collection)groupsOfTests.get(key)) {
                int bugLength = ((Bug[])test.getConstructorOrMethod().getMethod().getDeclaredAnnotationsByType(Bug.class)).length;
                List<String> testgroups = Arrays.asList(test.getGroups());
                if (testgroups.contains("sanity")) {
                    ++sanity;
                    if (bugLength == 1) {
                        ++bugSanity;
                    }
                } else if (testgroups.contains("core")) {
                    ++core;
                    if (bugLength == 1) {
                        ++bugCore;
                    }
                } else if (testgroups.contains("full")) {
                    ++full;
                    if (bugLength == 1) {
                        ++bugFull;
                    }
                } else {
                    ++notAllowed;
                    System.out.println("Test without group:" + test.getInstance().getClass().getSimpleName() + "#" + test.getMethodName());
                }
                if (bugLength != 1) continue;
                ++bugAnnotation;
            }
            try {
                this.fileWriter.append(key);
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(((Collection)groupsOfTests.get(key)).size()));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(bugAnnotation));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(sanity));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(bugSanity));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(core));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(bugCore));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(full));
                this.fileWriter.append(COMMA_DELIMITER);
                this.fileWriter.append(String.valueOf(bugFull));
                this.fileWriter.append(NEW_LINE_SEPARATOR);
            }
            catch (IOException e) {
                System.out.println("Error while writing on fileWriter !!!");
                e.printStackTrace();
            }
            System.out.println("NUMBER OF TESTS @Bug: " + bugAnnotation);
            System.out.println("NUMBER OF TESTS for :  " + key + " - SANITY " + sanity);
            System.out.println("NUMBER OF TESTS Bug - SANITY " + bugSanity);
            System.out.println("NUMBER OF TESTS for:  " + key + " - CORE " + core);
            System.out.println("NUMBER OF TESTS Bug - CORE " + bugCore);
            System.out.println("NUMBER OF TESTS for:  " + key + " - FULL " + full);
            System.out.println("NUMBER OF TESTS Bug - FULL " + bugFull);
            System.out.println("NUMBER OF TESTS for:  " + key + " - NO PHASE " + notAllowed);
            System.out.println("----------");
        }
        try {
            this.fileWriter.flush();
            this.fileWriter.close();
        }
        catch (IOException e) {
            System.out.println("Error while flushing/closing fileWriter !!!");
            e.printStackTrace();
        }
        System.exit(0);
    }

    public void onFinish(ISuite suite) {
    }

    private void createCVSFile() throws IOException {
        String FILE_HEADER = "TASRegression,total,totalbugs,sanity,sanitybugs,core,curebugs,full,fullbugs";
        this.fileWriter = new FileWriter("TASRegression.cvs");
        this.fileWriter.append(FILE_HEADER.toString());
        this.fileWriter.append(NEW_LINE_SEPARATOR);
    }
}

