/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.file.Paths;
import org.alfresco.utility.Utility;
import org.alfresco.utility.report.json.JsonClass;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.testng.ITestContext;
import org.testng.xml.XmlClass;

public class JsonSuite {
    private String name;
    private JsonClass testClass;
    private String jsonPathFile;
    private String startedAt;
    private String finishedAt;

    public JsonSuite(ITestContext context, String jsonPathFile) {
        this.jsonPathFile = jsonPathFile;
        this.setName(context.getCurrentXmlTest().getSuite().getName());
        this.setStartedAt(context.getStartDate().toString());
        this.setTestClass(new JsonClass(((XmlClass)context.getCurrentXmlTest().getClasses().get(0)).getName()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JsonClass getTestClass() {
        return this.testClass;
    }

    public void setTestClass(JsonClass testClass) {
        this.testClass = testClass;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(String startedAt) {
        this.startedAt = startedAt;
    }

    public String getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(String finishedAt) {
        this.finishedAt = finishedAt;
    }

    public void writeToDisk() throws Exception {
        Utility.checkObjectIsInitialized(this.jsonPathFile, "jsonPathFile");
        ObjectMapper mapper = new ObjectMapper();
        File out = Paths.get(this.jsonPathFile, String.format("%s-%s.json", this.getName(), System.currentTimeMillis())).toFile();
        mapper.writeValue(out, (Object)this);
    }
}

