/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.utility.testrail.model.Section;

public class TestCaseDestination {
    private List<String> sections = new ArrayList<String>();
    private Section rootSection = null;
    private Section destination = null;

    protected void fromAnnotation(TestRail testRailAnnotation) {
        if (testRailAnnotation != null) {
            for (int i = 0; i < testRailAnnotation.section().length; ++i) {
                if (testRailAnnotation.section()[i] == null) continue;
                if (testRailAnnotation.section()[i].contains("|")) {
                    this.sections.addAll(Arrays.asList(testRailAnnotation.section()[i].split(Pattern.quote("|"), -1)));
                    continue;
                }
                this.sections.add(testRailAnnotation.section()[i]);
            }
        }
    }

    public String getRootSectionName() {
        if (!this.getDestinationSections().isEmpty()) {
            return this.getDestinationSections().get(0);
        }
        return "UNDEFINED";
    }

    public List<String> getDestinationSections() {
        return this.sections;
    }

    public Section getRootSection() {
        return this.rootSection;
    }

    public void setRootSection(Section rootSection) {
        this.rootSection = rootSection;
    }

    public boolean hasRootSection() {
        return this.rootSection != null;
    }

    public boolean hasDestination() {
        return this.destination != null;
    }

    public Section getDestination() {
        return this.destination;
    }

    public void setDestination(Section destination) {
        this.destination = destination;
    }

    public List<String> getChildDestinationSection() {
        ArrayList<String> remaining = new ArrayList<String>();
        if (this.getDestinationSections().size() > 0) {
            for (int i = 1; i < this.getDestinationSections().size(); ++i) {
                remaining.add(this.getDestinationSections().get(i));
            }
        }
        return remaining;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[sections()=|");
        for (String s : this.getDestinationSections()) {
            sb.append(s).append("|");
        }
        sb.append("]");
        return sb.toString();
    }
}

