/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.UnrecognizedBrowser;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxDriverService;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.safari.SafariDriver;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Browser {
    FIREFOX{

        @Override
        public WebDriver createWebDriver(TasProperties properties) {
            Browser.setFirefoxDriver();
            FirefoxOptions options = 1.setFirefoxOptions(properties);
            if (SystemUtils.IS_OS_LINUX) {
                options.addArguments(new String[]{"--headless"});
                HashMap<String, CallSite> env = new HashMap<String, CallSite>();
                env.put("DISPLAY", (CallSite)((Object)(":" + properties.getDisplayXport())));
                return new FirefoxDriver((FirefoxDriverService)((GeckoDriverService.Builder)new GeckoDriverService.Builder().withEnvironment(env)).build(), options);
            }
            return new FirefoxDriver(options);
        }
    }
    ,
    CHROME{

        @Override
        public WebDriver createWebDriver(TasProperties properties) {
            Browser.setChromeDriver();
            HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
            chromePrefs.put("profile.default_content_settings.popups", 0);
            chromePrefs.put("download.default_directory", Browser.getDownloadLocation());
            ChromeOptions chromeOptions = new ChromeOptions();
            chromeOptions.addArguments(new String[]{"--start-maximized"});
            chromeOptions.addArguments(new String[]{String.format("--lang=%s", Browser.getBrowserLanguage(properties))});
            chromeOptions.setExperimentalOption("prefs", chromePrefs);
            return new ChromeDriver(chromeOptions);
        }
    }
    ,
    INTERNETEXPLORER{

        @Override
        public WebDriver createWebDriver(TasProperties properties) {
            return new InternetExplorerDriver();
        }
    }
    ,
    SAFARI{

        @Override
        public WebDriver createWebDriver(TasProperties properties) {
            return new SafariDriver();
        }
    };


    public abstract WebDriver createWebDriver(TasProperties var1);

    public static Browser getBrowserFromProperties(TasProperties properties) {
        return Browser.valueOf(properties.getBrowserName().toUpperCase());
    }

    public static FirefoxOptions setFirefoxOptions(TasProperties properties) {
        FirefoxOptions options = new FirefoxOptions();
        options.addPreference("browser.download.dir", (Object)Browser.getDownloadLocation());
        options.addPreference("browser.download.folderList", (Object)2);
        options.addPreference("browser.download.manager.alertOnEXEOpen", (Object)false);
        options.addPreference("browser.helperApps.neverAsk.saveToDisk", (Object)"application/msword, application/csv, application/ris, text/csv, image/png, application/pdf, text/html, text/plain, application/zip, application/x-zip, application/x-zip-compressed, application/download, application/octet-stream, application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/vnd.openxmlformats-officedocument.spreadsheetml.sheetapplication/vnd.openxmlformats-officedocument.presentationml.presentation");
        options.addPreference("browser.download.manager.showWhenStarting", (Object)false);
        options.addPreference("browser.download.manager.focusWhenStarting", (Object)false);
        options.addPreference("browser.download.useDownloadDir", (Object)true);
        options.addPreference("browser.helperApps.alwaysAsk.force", (Object)false);
        options.addPreference("browser.download.manager.alertOnEXEOpen", (Object)false);
        options.addPreference("browser.download.manager.closeWhenDone", (Object)true);
        options.addPreference("browser.download.manager.showAlertOnComplete", (Object)false);
        options.addPreference("intl.accept_languages", (Object)Browser.getBrowserLanguage(properties));
        options.setAcceptInsecureCerts(true);
        return options;
    }

    public static WebDriver fromProperties(TasProperties properties) {
        switch (properties.getBrowserName().toLowerCase()) {
            case "firefox": {
                Browser.setFirefoxDriver();
                FirefoxOptions firefoxOptions = Browser.setFirefoxOptions(properties);
                if (SystemUtils.IS_OS_LINUX) {
                    firefoxOptions.addArguments(new String[]{"--headless"});
                    HashMap<String, CallSite> env = new HashMap<String, CallSite>();
                    env.put("DISPLAY", (CallSite)((Object)(":" + properties.getDisplayXport())));
                    return new FirefoxDriver((FirefoxDriverService)((GeckoDriverService.Builder)new GeckoDriverService.Builder().withEnvironment(env)).build(), firefoxOptions);
                }
                return new FirefoxDriver(firefoxOptions);
            }
            case "chrome": {
                Browser.setChromeDriver();
                HashMap<String, Object> chromePrefs = new HashMap<String, Object>();
                chromePrefs.put("profile.default_content_settings.popups", 0);
                chromePrefs.put("download.default_directory", Browser.getDownloadLocation());
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.addArguments(new String[]{"--start-maximized"});
                chromeOptions.addArguments(new String[]{String.format("--lang=%s", Browser.getBrowserLanguage(properties))});
                chromeOptions.setExperimentalOption("prefs", chromePrefs);
                return new ChromeDriver(chromeOptions);
            }
            case "ie": {
                return new InternetExplorerDriver();
            }
            case "safari": {
                return new SafariDriver();
            }
        }
        throw new UnrecognizedBrowser(properties.getBrowserName());
    }

    private static void setChromeDriver() {
        String chromedriver = "not-defined";
        if (SystemUtils.IS_OS_WINDOWS) {
            chromedriver = "shared-resources/chromedriver/chromedriver.exe";
        } else if (SystemUtils.IS_OS_MAC) {
            chromedriver = "shared-resources/chromedriver/chromedriver_mac";
            Utility.getTestResourceFile(chromedriver).setExecutable(true);
        } else {
            chromedriver = "shared-resources/chromedriver/chromedriver_linux";
            Utility.getTestResourceFile(chromedriver).setExecutable(true);
        }
        System.setProperty("webdriver.chrome.driver", Utility.getTestResourceFile(chromedriver).toString());
    }

    private static void setFirefoxDriver() {
        String geckodriver = "Not-Defined";
        if (SystemUtils.IS_OS_WINDOWS) {
            geckodriver = "shared-resources/geckodriver/geckodriver.exe";
        } else if (SystemUtils.IS_OS_MAC) {
            geckodriver = "shared-resources/geckodriver/geckodriver_mac";
            Utility.getTestResourceFile(geckodriver).setExecutable(true);
        } else {
            geckodriver = "shared-resources/geckodriver/geckodriver_linux";
            Utility.getTestResourceFile(geckodriver).setExecutable(true);
        }
        System.setProperty("webdriver.gecko.driver", Utility.getTestResourceFile(geckodriver).toString());
    }

    private static String getDownloadLocation() {
        String srcRoot = System.getProperty("user.dir") + File.separator;
        String testDataFolder = srcRoot + "testdata" + File.separator;
        return testDataFolder;
    }

    private static String getBrowserLanguage(TasProperties properties) {
        if (!StringUtils.isEmpty((CharSequence)properties.getBrowserLanguageCountry())) {
            return properties.getBrowserLanguage() + "-" + properties.getBrowserLanguageCountry();
        }
        return properties.getBrowserLanguage();
    }
}

