/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.net.MalformedURLException;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.web.browser.Browser;
import org.alfresco.utility.web.browser.WebBrowser;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeOptions;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WebBrowserFactory
implements FactoryBean<WebBrowser> {
    private static final Logger LOG = LoggerFactory.getLogger(WebBrowserFactory.class);
    @Autowired
    TasProperties properties;

    public WebBrowser getWebBrowser() throws Exception {
        WebBrowser webBrowser = this.properties.isGridEnabled() ? new WebBrowser((WebDriver)WebBrowserFactory.getRemoteWebDriver(this.properties), this.properties) : new WebBrowser(Browser.fromProperties(this.properties), this.properties);
        if (!this.properties.getBrowserName().equalsIgnoreCase("chrome") && !this.properties.isGridEnabled()) {
            webBrowser.maximize();
        }
        return webBrowser;
    }

    public Class<?> getObjectType() {
        return WebBrowser.class;
    }

    public boolean isSingleton() {
        return false;
    }

    private static RemoteWebDriver getRemoteWebDriver(TasProperties properties) throws MalformedURLException {
        String browserName;
        LOG.info("Using RemoteWebDriver on Hub URL {}", (Object)properties.getGridUrl());
        return switch (browserName = properties.getBrowserName().toLowerCase()) {
            case "firefox" -> {
                FirefoxOptions firefoxOptions = Browser.setFirefoxOptions(properties);
                firefoxOptions.setCapability("browserVersion", properties.getBrowserVersion());
                firefoxOptions.setCapability("platformName", properties.getEnvPlatformName());
                yield new RemoteWebDriver(properties.getGridUrl(), (Capabilities)firefoxOptions);
            }
            case "chrome" -> {
                ChromeOptions chromeOptions = new ChromeOptions();
                chromeOptions.setCapability("browserVersion", properties.getBrowserVersion());
                chromeOptions.setCapability("platformName", properties.getEnvPlatformName());
                yield new RemoteWebDriver(properties.getGridUrl(), (Capabilities)chromeOptions);
            }
            case "edge" -> {
                EdgeOptions edgeOptions = new EdgeOptions();
                edgeOptions.setCapability("browserVersion", properties.getBrowserVersion());
                edgeOptions.setCapability("platformName", properties.getEnvPlatformName());
                yield new RemoteWebDriver(properties.getGridUrl(), (Capabilities)edgeOptions);
            }
            default -> throw new IllegalArgumentException("Unsupported browser: " + properties.getBrowserName());
        };
    }

    public WebBrowser getObject() throws Exception {
        return this.getWebBrowser();
    }
}

