/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.renderer;

import java.time.Duration;
import java.util.function.Function;
import org.alfresco.utility.web.browser.WebBrowser;
import org.alfresco.utility.web.renderer.RenderElement;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.WebDriverWait;

public class RenderPageLoaded
extends RenderElement {
    @Override
    protected void doWork(By locator, WebBrowser browser, long timeOutInSeconds) {
        this.LOG.info("Dom Completed in {} miliseconds", (Object)this.domEventCompleted(browser));
        this.waitForPageLoad(browser, timeOutInSeconds);
    }

    public String domEventCompleted(WebBrowser browser) {
        String js = "try{window.performance = window.performance || window.mozPerformance || window.msPerformance || window.webkitPerformance || {};return(parseInt(window.performance.timing.domContentLoadedEventEnd)-parseInt(window.performance.timing.navigationStart));}catch(e){}";
        Object val = ((JavascriptExecutor)browser).executeScript(js, new Object[0]);
        return val.toString();
    }

    public void waitForPageLoad(WebBrowser browser, long timeOutInSeconds) {
        ExpectedCondition<Boolean> expectation = new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete");
            }
        };
        try {
            new WebDriverWait(browser.getDriver(), Duration.ofSeconds(timeOutInSeconds)).until((Function)expectation);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

