/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:default.properties"}), @PropertySource(value={"classpath:${environment}.properties"}, ignoreResourceNotFound=true)})
public class TasAisProperties {
    @Value(value="${identity-service.realm:alfresco}")
    String realm;
    @Value(value="${identity-service.realm-public-key:#{null}}")
    String realmKey;
    @Value(value="${identity-service.auth-server-url:#{null}}")
    String authServerUrl;
    @Value(value="${identity-service.ssl-required:external}")
    String sslRequired;
    @Value(value="${identity-service.confidential-port:0}")
    int confidentialPort;
    @Value(value="${identity-service.resource:alfresco}")
    String resource;
    @Value(value="${identity-service.use-resource-role-mappings:false}")
    boolean useResourceRoleMappings;
    @Value(value="${identity-service.enable-cors:false}")
    boolean enableCors;
    @Value(value="${identity-service.cors-max-age:-1}")
    int corsMaxAge;
    @Value(value="${identity-service.cors-allowed-headers:#{null}}")
    String corsAllowedHeaders;
    @Value(value="${identity-service.cors-allowed-methods:#{null}}")
    String corsAllowedMethods;
    @Value(value="${identity-service.cors-exposed-headers:#{null}}")
    String corsExposedHeaders;
    @Value(value="${identity-service.expose-token:false}")
    boolean exposeToken;
    @Value(value="${identity-service.bearer-only:false}")
    boolean bearerOnly;
    @Value(value="${identity-service.autodetect-bearer-only:false}")
    boolean autodetectBearerOnly;
    @Value(value="${identity-service.enable-basic-auth:false}")
    boolean enableBasicAuth;
    @Value(value="${identity-service.public-client:false}")
    boolean publicClient;
    @Value(value="${identity-service.allow-any-hostname:false}")
    boolean allowAnyHostname;
    @Value(value="${identity-service.disable-trust-manager:false}")
    boolean disableTrustManager;
    @Value(value="${identity-service.truststore:#{null}}")
    String truststore;
    @Value(value="${identity-service.truststore-password:#{null}}")
    String truststorePassword;
    @Value(value="${identity-service.client-keystore:#{null}}")
    String clientKeystore;
    @Value(value="${identity-service.client-keystore-password:#{null}}")
    String clientKeystorePassword;
    @Value(value="${identity-service.client-key-password:#{null}}")
    String clientKeyPassword;
    @Value(value="${identity-service.connection-pool-size:20}")
    int connectionPoolSize;
    @Value(value="${identity-service.always-refresh-token:false}")
    boolean alwaysRefreshToken;
    @Value(value="${identity-service.register-node-at-startup:false}")
    boolean registerNodeAtStartup;
    @Value(value="${identity-service.register-node-period:-1}")
    int registerNodePeriod;
    @Value(value="${identity-service.token-store:#{null}}")
    String tokenStore;
    @Value(value="${identity-service.principal-attribute:#{null}}")
    String principalAttribute;
    @Value(value="${identity-service.turn-off-change-session-id-on-login:false}")
    boolean turnOffChangeSessionIdOnLogin;
    @Value(value="${identity-service.token-minimum-time-to-live:0}")
    int tokenMinimumTimeToLive;
    @Value(value="${identity-service.min-time-between-jwks-requests:10}")
    int minTimeBetweenJwksRequests;
    @Value(value="${identity-service.public-key-cache-ttl:86400}")
    int publicKeyCacheTtl;
    @Value(value="${identity-service.enable-pkce:false}")
    boolean enablePkce;
    @Value(value="${identity-service.ignore-oauth-query-parameter:false}")
    boolean ignoreOAuthQueryParameter;
    @Value(value="${identity-service.credentials.secret:}")
    String credentialsSecret;
    @Value(value="${identity-service.credentials.provider:#{null}}")
    String credentialsProvider;
    @Value(value="${identity-service.adminUsername:admin}")
    String adminUsername;
    @Value(value="${identity-service.adminPassword:admin}")
    String adminPassword;

    public String getAdminUsername() {
        return this.adminUsername;
    }

    public void setAdminUsername(String adminUsername) {
        this.adminUsername = adminUsername;
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getResource() {
        return this.resource;
    }
}

