/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import junit.framework.Assert;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.data.auth.GroupManageable;
import org.alfresco.utility.data.auth.UserManageable;
import org.alfresco.utility.exception.TestStepException;
import org.alfresco.utility.model.GroupModel;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataOpenLDAP {
    @Autowired
    private TasProperties tasProperties;
    private static final String USER_SEARCH_BASE = "cn=%s,ou=users,dc=ldap,dc=dev,dc=alfresco,dc=me";
    private static final String GROUP_SEARCH_BASE = "cn=%s,ou=groups,dc=ldap,dc=dev,dc=alfresco,dc=me";
    private static final String SUBGROUP_SEARCH_BASE = "cn=%s, cn=%s,ou=groups,dc=ldap,dc=dev,dc=alfresco,dc=me";
    private DirContext context;

    public Builder perform() throws NamingException {
        return new Builder();
    }

    public String getUserId(UserModel user) {
        return String.format(USER_SEARCH_BASE, user.getUsername());
    }

    public class Builder
    implements UserManageable,
    GroupManageable {
        public Builder() throws NamingException {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", DataOpenLDAP.this.tasProperties.getAuthContextFactory());
            properties.put("java.naming.provider.url", DataOpenLDAP.this.tasProperties.getOLdapURL());
            properties.put("java.naming.security.authentication", DataOpenLDAP.this.tasProperties.getSecurityAuth());
            properties.put("java.naming.security.principal", DataOpenLDAP.this.tasProperties.getOLdapSecurityPrincipal());
            properties.put("java.naming.security.credentials", DataOpenLDAP.this.tasProperties.getOLdapSecurityCredentials());
            DataOpenLDAP.this.context = new InitialDirContext(properties);
        }

        @Override
        public Builder createUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Add user %s", user.getUsername()));
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute sn = new BasicAttribute("sn");
            BasicAttribute uid = new BasicAttribute("uid");
            BasicAttribute userPassword = new BasicAttribute("userPassword");
            objectClass.add(ObjectType.user.toString());
            sn.add(user.getLastName());
            uid.add(user.getUsername());
            userPassword.add(user.getPassword());
            attributes.put(objectClass);
            attributes.put(sn);
            attributes.put(uid);
            attributes.put(userPassword);
            DataOpenLDAP.this.context.createSubcontext(String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername()), (Attributes)attributes);
            return this;
        }

        @Override
        public Builder deleteUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Delete user %s", user.getUsername()));
            DataOpenLDAP.this.context.destroySubcontext(String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername()));
            return this;
        }

        @Override
        public Builder updateUser(UserModel user, HashMap<String, String> attributes) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Update user %s", user.getUsername()));
            ModificationItem[] items = new ModificationItem[attributes.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                BasicAttribute attribute = new BasicAttribute(entry.getKey(), entry.getValue());
                items[i] = new ModificationItem(2, attribute);
                ++i;
            }
            DataOpenLDAP.this.context.modifyAttributes(String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername()), items);
            return this;
        }

        @Override
        public Builder createGroup(GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Create group %s", group.getDisplayName()));
            Random random = new Random();
            int gidNumberValue = random.nextInt(10000);
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute gidNumber = new BasicAttribute("gidNumber");
            BasicAttribute cn = new BasicAttribute("cn");
            objectClass.add(ObjectType.group.toString());
            gidNumber.add(Integer.toString(gidNumberValue));
            cn.add(group.getDisplayName());
            attributes.put(objectClass);
            attributes.put(gidNumber);
            attributes.put(cn);
            DataOpenLDAP.this.context.createSubcontext(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), (Attributes)attributes);
            return this;
        }

        public Builder createSubGroup(GroupModel subGroup, GroupModel mainGroup) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Create group %s", subGroup.getDisplayName()));
            Random random = new Random();
            int gidNumberValue = random.nextInt(10000);
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute gidNumber = new BasicAttribute("gidNumber");
            BasicAttribute cn = new BasicAttribute("cn");
            BasicAttribute cnGroup = new BasicAttribute("cn");
            objectClass.add(ObjectType.group.toString());
            gidNumber.add(Integer.toString(gidNumberValue));
            cn.add(subGroup.getDisplayName());
            cnGroup.add(mainGroup.getDisplayName());
            attributes.put(objectClass);
            attributes.put(gidNumber);
            attributes.put(cn);
            attributes.put(cnGroup);
            DataOpenLDAP.this.context.createSubcontext(String.format(DataOpenLDAP.SUBGROUP_SEARCH_BASE, subGroup.getDisplayName(), mainGroup.getDisplayName()), (Attributes)attributes);
            return this;
        }

        @Override
        public GroupManageable deleteGroup(GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Delete group %s", group.getDisplayName()));
            DataOpenLDAP.this.context.destroySubcontext(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()));
            return this;
        }

        public Builder deleteSubgroup(GroupModel subgroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Delete subgroup %s from group %s", subgroup.getDisplayName(), group.getDisplayName()));
            DataOpenLDAP.this.context.destroySubcontext(String.format(DataOpenLDAP.SUBGROUP_SEARCH_BASE, subgroup.getDisplayName(), group.getDisplayName()));
            return this;
        }

        @Override
        public GroupManageable addUserToGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Add user %s to group %s", user.getUsername(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("memberUID", String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, memberAttribute)};
            DataOpenLDAP.this.context.modifyAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), member);
            return this;
        }

        public Builder addGroupAsMemberOfAnotherGroup(GroupModel childGroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Add group %s as member of group %s", childGroup.getDisplayName(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("memberUID", String.format(DataOpenLDAP.GROUP_SEARCH_BASE, childGroup.getDisplayName()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(1, memberAttribute)};
            DataOpenLDAP.this.context.modifyAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), member);
            return this;
        }

        @Override
        public GroupManageable removeUserFromGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Remove user %s from group %s", user.getUsername(), group.getDisplayName()));
            BasicAttribute memberAttribute = new BasicAttribute("memberUid", String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername()));
            ModificationItem[] member = new ModificationItem[]{new ModificationItem(3, memberAttribute)};
            DataOpenLDAP.this.context.modifyAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), member);
            return this;
        }

        public SearchResult searchForObjectClass(String name, ObjectType typeOfClass, String base) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(objectClass=%s)", typeOfClass.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataOpenLDAP.this.context.search(String.format(base, name), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            if (results.hasMoreElements()) {
                return (SearchResult)results.nextElement();
            }
            return null;
        }

        private SearchResult searchGeneratedData(String partialName, ObjectType typeOfClass, String base) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(objectClass=%s)", typeOfClass.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataOpenLDAP.this.context.search(base.replace("cn=%s,", ""), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            while (results.hasMoreElements()) {
                SearchResult rez = (SearchResult)results.nextElement();
                if (!rez.getNameInNamespace().contains(partialName)) continue;
                return rez;
            }
            return null;
        }

        public Builder deleteBulkUsers() throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Delete all users which start with 'user-'", new Object[0]));
            SearchResult rez = this.searchGeneratedData("cn=user-", ObjectType.user, DataOpenLDAP.USER_SEARCH_BASE);
            while (rez != null) {
                DataOpenLDAP.this.context.destroySubcontext(rez.getNameInNamespace());
                rez = this.searchGeneratedData("cn=user-", ObjectType.user, DataOpenLDAP.USER_SEARCH_BASE);
            }
            return this;
        }

        public Builder deleteBulkGroups() throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Delete all groups which start with 'group-'", new Object[0]));
            SearchResult rez = this.searchGeneratedData("cn=group-", ObjectType.group, DataOpenLDAP.GROUP_SEARCH_BASE);
            while (rez != null) {
                DataOpenLDAP.this.context.destroySubcontext(rez.getNameInNamespace());
                rez = this.searchGeneratedData("cn=group-", ObjectType.group, DataOpenLDAP.GROUP_SEARCH_BASE);
            }
            return this;
        }

        public Builder addBulkUsersInGroups(int noGroups, int noUsersPerGroup) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Add %s groups with %s users in each group", noGroups, noUsersPerGroup));
            HashMap usersGroupsMap = new HashMap();
            for (int i = 0; i < noGroups; ++i) {
                GroupModel testGroup = GroupModel.getRandomGroupModel();
                this.createGroup(testGroup).assertGroupExists(testGroup);
                ArrayList<UserModel> groupUsers = new ArrayList<UserModel>();
                for (int j = 0; j < noUsersPerGroup; ++j) {
                    UserModel testUser = UserModel.getRandomUserModel();
                    this.createUser(testUser).addUserToGroup(testUser, testGroup);
                    groupUsers.add(testUser);
                }
                usersGroupsMap.put(testGroup, groupUsers);
            }
            return this;
        }

        @Override
        public UserManageable assertUserExists(UserModel user) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert user %s exists", user.getUsername()));
            Assert.assertNotNull((Object)this.searchForObjectClass(user.getUsername(), ObjectType.user, DataOpenLDAP.USER_SEARCH_BASE));
            return this;
        }

        @Override
        public UserManageable assertUserDoesNotExist(UserModel user) throws NamingException, TestStepException {
            Step.STEP(String.format("[OpenLDAP] Assert user %s does not exist", user.getUsername()));
            Assert.assertNull((Object)this.searchForObjectClass(user.getUsername(), ObjectType.user, DataOpenLDAP.USER_SEARCH_BASE));
            return this;
        }

        @Override
        public GroupManageable assertGroupExists(GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert group %s exists", group.getDisplayName()));
            Assert.assertNotNull((Object)this.searchForObjectClass(group.getDisplayName(), ObjectType.group, DataOpenLDAP.GROUP_SEARCH_BASE));
            return this;
        }

        public Builder assertSubgroupExists(GroupModel subgroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert subgroup %s from group %s exists", subgroup.getDisplayName(), group.getDisplayName()));
            Assert.assertNotNull((Object)this.searchForObjectClass(subgroup.getDisplayName(), ObjectType.group, String.format("%s,%s", "cn=%s", String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()))));
            return this;
        }

        @Override
        public GroupManageable assertGroupDoesNotExist(GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert group %s does not exist", group.getDisplayName()));
            Assert.assertNull((Object)this.searchForObjectClass(group.getDisplayName(), ObjectType.group, DataOpenLDAP.GROUP_SEARCH_BASE));
            return this;
        }

        @Override
        public GroupManageable assertUserIsMemberOfGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert user %s is member of group %s", user.getUsername(), group.getDisplayName()));
            Attributes membership = DataOpenLDAP.this.context.getAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), new String[]{"memberUid"});
            Assert.assertTrue((boolean)membership.toString().contains(String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername())));
            return this;
        }

        public Builder assertGroupIsMemberOfGroup(GroupModel childGroup, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert group %s is member of group %s", childGroup.getDisplayName(), group.getDisplayName()));
            Attributes membership = DataOpenLDAP.this.context.getAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), new String[]{"memberUid"});
            Assert.assertTrue((boolean)membership.toString().contains(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, childGroup.getDisplayName())));
            return this;
        }

        @Override
        public GroupManageable assertUserIsNotMemberOfGroup(UserModel user, GroupModel group) throws NamingException {
            Step.STEP(String.format("[OpenLDAP] Assert user %s is not member of group %s", user.getUsername(), group.getDisplayName()));
            Attributes membership = DataOpenLDAP.this.context.getAttributes(String.format(DataOpenLDAP.GROUP_SEARCH_BASE, group.getDisplayName()), new String[]{"member"});
            Assert.assertFalse((boolean)membership.toString().contains(String.format(DataOpenLDAP.USER_SEARCH_BASE, user.getUsername())));
            return this;
        }
    }

    static enum ObjectType {
        user("inetOrgPerson"),
        group("posixGroup");

        private final String objectType;

        private ObjectType(String objectType) {
            this.objectType = objectType;
        }

        public String toString() {
            return this.objectType;
        }
    }
}

