/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.alfresco.utility.data.provider.XMLPropertyData;

@XmlType(name="aspect")
public class XMLAspectData {
    private String name;
    private List<XMLPropertyData> properties = new ArrayList<XMLPropertyData>();

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlElementWrapper
    @XmlElement(name="property")
    public List<XMLPropertyData> getProperties() {
        return this.properties;
    }

    public void setProperties(List<XMLPropertyData> properties) {
        this.properties = properties;
    }

    public void addProperty(XMLPropertyData property) {
        this.getProperties().add(property);
    }

    public Map<String, Object> getPropertiesAsHashMap() {
        HashMap<String, Object> allProps = new HashMap<String, Object>();
        for (XMLPropertyData p : this.properties) {
            try {
                int value = Integer.parseInt(p.getValue());
                allProps.put(p.getName(), value);
            }
            catch (NumberFormatException e) {
                allProps.put(p.getName(), p.getValue());
            }
        }
        return allProps;
    }

    public boolean hasProperties() {
        return !this.getProperties().isEmpty();
    }

    public String toString() {
        StringBuilder info = new StringBuilder();
        info.append("aspect[name='").append(this.getName()).append("', properties=[");
        for (XMLPropertyData p : this.properties) {
            info.append("{").append(p.getName()).append("=").append(p.getValue()).append("} ");
        }
        info.append("]");
        return info.toString();
    }
}

