/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.network;

import java.io.IOException;
import java.util.HashMap;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.exception.JmxException;
import org.alfresco.utility.network.Jmx;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JmxClient
implements Jmx {
    @Autowired
    protected TasProperties properties;
    static Logger LOG = LogFactory.getLogger();
    private JMXConnector jmxConnector;

    @Override
    public Object readProperty(String objectName, String attributeName) throws Exception {
        JMXConnector connector = this.createJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName objectJmx = new ObjectName(objectName);
        Object value = mBSC.getAttribute(objectJmx, attributeName);
        LOG.info("JMX Object [{}] with attribute [{}] has value [{}]", new Object[]{objectJmx, attributeName, value.toString()});
        return value;
    }

    public void closeConnection() throws IOException {
        if (this.jmxConnector != null) {
            this.jmxConnector.close();
        }
    }

    @Override
    public Object writeProperty(String objectName, String attributeName, Object attributeValue) throws Exception {
        JMXConnector connector = this.createJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName objectJmx = new ObjectName(objectName);
        mBSC.setAttribute(ObjectName.getInstance(objectName), new Attribute(attributeName, attributeValue));
        LOG.info("Updating object [{}.{}] with value [{}] via JmxClient", new Object[]{objectName, attributeName, attributeValue});
        this.refreshServerProperty(objectName, JmxPropertyOperation.stop);
        this.refreshServerProperty(objectName, JmxPropertyOperation.start);
        return mBSC.getAttribute(objectJmx, attributeName);
    }

    public String getStringNameFromJmxObject(String objectName) throws Exception {
        JMXConnector connector = this.getJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName wasObjectName = new ObjectName("*" + objectName + "*,cell=*,node=*,process=*");
        Set<ObjectInstance> set = mBSC.queryMBeans(wasObjectName, null);
        ObjectInstance oi = (ObjectInstance)set.toArray()[0];
        ObjectName oName = oi.getObjectName();
        return oName.toString();
    }

    private JMXConnector getJmxConnection() throws IOException, JmxException {
        return this.createJmxConnection();
    }

    private JMXConnector createJmxConnection() throws JmxException, IOException {
        if (this.jmxConnector == null) {
            JMXServiceURL jmxUrl = new JMXServiceURL(this.properties.getJmxUrl());
            HashMap<String, String[]> env = new HashMap<String, String[]>();
            env.put("jmx.remote.credentials", new String[]{this.properties.getJmxUser(), this.properties.getJmxPassword()});
            LOG.info("Create JMX Connection using [{}] with username [{}] and password [{}] ", new Object[]{this.properties.getJmxUrl(), this.properties.getJmxUser(), this.properties.getJmxPassword()});
            this.jmxConnector = JMXConnectorFactory.connect(jmxUrl, env);
        }
        return this.jmxConnector;
    }

    public void refreshServerProperty(String objectName, JmxPropertyOperation operation) throws Exception {
        JMXConnector connector = this.createJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName objectJmx = new ObjectName(objectName);
        try {
            mBSC.invoke(objectJmx, operation.toString(), new Object[0], new String[0]);
        }
        catch (Exception e) {
            LOG.error(String.format("Object [%s] does not have operation [%s]", objectJmx, operation.toString()));
        }
    }

    @Override
    public boolean isJMXEnabled() {
        boolean isAlive = false;
        try {
            this.createJmxConnection();
            isAlive = true;
        }
        catch (Exception e) {
            LOG.error("Cannot establish JMX Connection: {}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return isAlive;
    }

    @Override
    public Object executeJMXMethod(String objectName, String methodName, Object ... pArgs) throws Exception {
        JMXConnector connector = this.getJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName objectJmx = new ObjectName(objectName);
        LOG.info("Executing methodName {} on objectName {}  via JmxClient", (Object)methodName, (Object)objectName);
        return mBSC.invoke(objectJmx, methodName, pArgs, new String[0]);
    }

    public Object executeJMXMethod(String objectName, String methodName, String[] signature, Object ... pArgs) throws Exception {
        JMXConnector connector = this.getJmxConnection();
        MBeanServerConnection mBSC = connector.getMBeanServerConnection();
        ObjectName objectJmx = new ObjectName(objectName);
        LOG.info("Executing methodName {} with signature {} on objectName {}  via JmxClient", new Object[]{methodName, signature, objectName});
        return mBSC.invoke(objectJmx, methodName, pArgs, signature);
    }

    public static enum JmxPropertyOperation {
        stop,
        start;

    }
}

