/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report;

import com.relevantcodes.extentreports.ExtentReports;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Properties;
import org.alfresco.utility.LogFactory;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.TestConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class ReportManager {
    static Logger LOG = LogFactory.getLogger();
    static ExtentReports extent;

    public static synchronized ExtentReports getReporter() throws TestConfigurationException, URISyntaxException {
        if (extent == null) {
            String reportPrefix;
            Properties properties = Utility.getProperties(ReportManager.class, Utility.getEnvironmentPropertyFile());
            String reportHtmlPath = properties.getProperty("reports.path");
            if (StringUtils.isEmpty((CharSequence)reportHtmlPath)) {
                reportHtmlPath = "./target/reports";
            }
            String reportName = (reportPrefix = properties.getProperty("reports.prefix")) == null || reportPrefix.isEmpty() ? "report.html" : String.format("%s-report.html", reportPrefix);
            reportHtmlPath = Paths.get(reportHtmlPath, reportName).toFile().getPath();
            extent = new ExtentReports(reportHtmlPath, Boolean.valueOf(true));
            LOG.info("Initializing ReportManager to generate HTML report at:{}", (Object)reportHtmlPath);
            URL reportConfigUrl = ReportManager.class.getClassLoader().getResource("shared-resources/report/alfresco-report-config.xml");
            try {
                extent.loadConfig(Paths.get(reportConfigUrl.toURI()).toFile());
                LOG.info("Loaded ReportManager configuration file :{}", (Object)reportHtmlPath);
            }
            catch (Exception e) {
                LOG.error("Loaded ReportManager configuration file: {}. Error: {}", (Object)reportConfigUrl, (Object)e.getMessage());
            }
            extent.addSystemInfo("Alfresco Server", String.format("%s://%s:%s", Utility.getSystemOrFileProperty("alfresco.scheme", properties), Utility.getSystemOrFileProperty("alfresco.server", properties), Utility.getSystemOrFileProperty("alfresco.port", properties)));
        }
        return extent;
    }
}

