/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.report.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.testng.ITestResult;

public class JsonTest {
    private String name;
    private String startedAt;
    private String finishedAt;
    private String description;
    private String exception;
    private String status;
    private List<String> groups = new ArrayList<String>();
    @JsonProperty(value="isConfig")
    private boolean isConfig;

    public JsonTest(ITestResult result) {
        this.setName(result.getMethod().getMethodName());
        this.setStartedAt(result.getStartMillis());
        this.setFinishedAt(result.getEndMillis());
        this.setStatus(this.getHumanReadableStatus(result.getStatus()));
        this.setGroups(Arrays.asList(result.getMethod().getGroups()));
        if (!result.isSuccess() && result.getThrowable() != null && result.getThrowable().getStackTrace() != null) {
            StringWriter sw = new StringWriter();
            result.getThrowable().printStackTrace(new PrintWriter(sw));
            this.setException(sw.toString());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(long startedAt) {
        this.startedAt = this.dateFormat(startedAt);
    }

    public String getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(long finishedAt) {
        this.finishedAt = this.dateFormat(finishedAt);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    private String dateFormat(long miliseconds) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(miliseconds);
    }

    private String getHumanReadableStatus(int value) {
        String status = "";
        switch (value) {
            case 1: {
                status = "PASSED";
                break;
            }
            case 2: {
                status = "FAILED";
                break;
            }
            case 3: {
                status = "SKIPPED";
                break;
            }
            case 4: {
                status = "PASSED";
                break;
            }
        }
        return status;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void setGroups(List<String> groups) {
        this.groups = groups;
    }
}

