/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.DatatypeConverter;
import org.alfresco.utility.Utility;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.testrail.ExecutionType;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.utility.testrail.model.Run;
import org.alfresco.utility.testrail.model.Section;
import org.alfresco.utility.testrail.model.TestCase;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestResult;

public class TestRailApi {
    static Logger LOG = LoggerFactory.getLogger((String)"testrail");
    private static final int TEMPLATE_ID = 1;
    private static final int TEST_PRIORITY_MEDIUM = 2;
    Properties testRailProperties = new Properties();
    private String username;
    private String password;
    private String endPointApiPath;
    public int currentProjectID;
    private String currentRun;
    private boolean configurationError = true;
    public int suiteId;
    protected String serverUrl;
    private TestCase tmpTestCase = null;

    public TestCase getCurrentTestCase() {
        return this.tmpTestCase;
    }

    public void setCurrentTestCase(TestCase testCase) {
        this.tmpTestCase = testCase;
    }

    public TestRailApi() {
        InputStream defaultPropsInputStream = this.getClass().getClassLoader().getResourceAsStream(Utility.getEnvironmentPropertyFile());
        if (defaultPropsInputStream != null) {
            try {
                this.testRailProperties.load(defaultPropsInputStream);
                this.username = Utility.getSystemOrFileProperty("testManagement.username", this.testRailProperties);
                Utility.checkObjectIsInitialized(this.username, "username");
                this.password = Utility.getSystemOrFileProperty("testManagement.apiKey", this.testRailProperties);
                Utility.checkObjectIsInitialized(this.password, "password");
                this.endPointApiPath = Utility.getSystemOrFileProperty("testManagement.endPoint", this.testRailProperties) + "index.php?/api/v2/";
                Utility.checkObjectIsInitialized(this.endPointApiPath, "endPointApiPath");
                this.currentProjectID = Integer.parseInt(Utility.getSystemOrFileProperty("testManagement.project", this.testRailProperties));
                Utility.checkObjectIsInitialized(this.currentProjectID, "currentProjectID");
                this.currentRun = Utility.getSystemOrFileProperty("testManagement.testRun", this.testRailProperties);
                Utility.checkObjectIsInitialized(this.currentRun, "currentRun");
                this.suiteId = Integer.valueOf(Utility.getSystemOrFileProperty("testManagement.suiteId", this.testRailProperties));
                Utility.checkObjectIsInitialized(this.suiteId, "suiteId");
                this.serverUrl = String.format("%s://%s:%s", this.testRailProperties.getProperty("alfresco.scheme"), this.testRailProperties.getProperty("alfresco.server"), this.testRailProperties.getProperty("alfresco.port"));
                this.configurationError = false;
            }
            catch (Exception e) {
                LOG.error("Cannot initialize Test Management Setting from default.properties file");
            }
        } else {
            LOG.error("Cannot initialize Test Management Setting from {} file", (Object)Utility.getEnvironmentPropertyFile());
        }
    }

    protected <T> T toClass(Object response, Class<T> classz) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(response.toString(), classz);
        }
        catch (JsonParseException e) {
            LOG.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOG.error(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return null;
    }

    protected <T> List<T> toCollection(Object response, Class<T> classz) {
        ObjectMapper mapper = new ObjectMapper();
        List list = null;
        try {
            list = (List)mapper.readValue(response.toString(), (JavaType)TypeFactory.defaultInstance().constructCollectionType(List.class, classz));
        }
        catch (JsonParseException e) {
            LOG.error(e.getMessage());
        }
        catch (JsonMappingException e) {
            LOG.error(e.getMessage());
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
        return list;
    }

    public boolean hasConfigurationErrors() {
        return this.configurationError;
    }

    protected Object getRequest(String path) throws Exception {
        URL endPointURL = new URL(this.endPointApiPath + path);
        HttpURLConnection conn = (HttpURLConnection)endPointURL.openConnection();
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", this.username, this.password).getBytes()));
        return this.parseRespose(conn);
    }

    protected Object postRequest(String path, Object data) throws Exception {
        URL endPointURL = new URL(this.endPointApiPath + path);
        HttpURLConnection conn = (HttpURLConnection)endPointURL.openConnection();
        conn.addRequestProperty("Content-Type", "application/json");
        conn.addRequestProperty("Authorization", "Basic " + DatatypeConverter.printBase64Binary((byte[])String.format("%s:%s", this.username, this.password).getBytes()));
        if (data != null) {
            byte[] block = JSONValue.toJSONString((Object)data).getBytes("UTF-8");
            conn.setDoOutput(true);
            OutputStream ostream = conn.getOutputStream();
            ostream.write(block);
            ostream.flush();
        }
        return this.parseRespose(conn);
    }

    private Object parseRespose(HttpURLConnection conn) throws Exception, IOException, UnsupportedEncodingException {
        InputStream istream;
        int status = conn.getResponseCode();
        if (status != 200) {
            istream = conn.getErrorStream();
            if (istream == null) {
                throw new Exception("TestRail API return HTTP " + status + " (No additional error message received)");
            }
        } else {
            istream = conn.getInputStream();
        }
        Object text = "";
        if (istream != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                text = (String)text + line;
                text = (String)text + System.getProperty("line.separator");
            }
            reader.close();
        }
        Object result = text != "" ? JSONValue.parse((String)text) : new JSONObject();
        if (status != 200) {
            JSONObject obj;
            Object error = "No additional error message received";
            if (result != null && result instanceof JSONObject && (obj = (JSONObject)result).containsKey((Object)"error")) {
                error = "\"" + (String)obj.get((Object)"error") + "\"";
            }
            throw new Exception("TestRail API returned HTTP " + status + "(" + (String)error + ")");
        }
        return result;
    }

    public List<Section> getSectionsOfCurrentProject() {
        return this.getSections(this.currentProjectID);
    }

    public Section addNewSection(String name, int parent_id, int projectID, int suite_id) {
        Section s = new Section();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("suite_id", suite_id);
        data.put("name", name);
        data.put("parent_id", parent_id);
        LOG.info("Add missing section [{}] as child of parent section with ID: {}", (Object)name, (Object)parent_id);
        try {
            Object response = this.postRequest("add_section/" + projectID, data);
            s = this.toClass(response, Section.class);
        }
        catch (Exception e) {
            LOG.error("Cannot add new section: {}", (Object)e.getMessage());
        }
        return s;
    }

    public Run getRun(String name, int projectID) {
        for (Run run : this.getRuns(projectID)) {
            if (!run.getName().equals(name) || run.isIs_completed()) continue;
            return run;
        }
        return null;
    }

    public void addTestCase(ITestResult result, Section section, TestRail annotation) {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("title", result.getMethod().getMethodName());
            data.put("template_id", TEMPLATE_ID);
            data.put("type_id", annotation.testType().value());
            data.put("custom_auto_ref", this.getFullTestCaseName(result));
            data.put("custom_executiontype", true);
            ArrayList<Integer> executionTypeList = new ArrayList<Integer>();
            for (ExecutionType et : annotation.executionType()) {
                executionTypeList.add(et.value());
            }
            data.put("custom_exce_type", executionTypeList);
            data.put("custom_description", annotation.description());
            data.put("priority_id", 2);
            data.put("custom_platform", 1);
            Object response = this.postRequest("add_case/" + section.getId(), data);
            this.setCurrentTestCase(this.toClass(response, TestCase.class));
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public void addTestSteps(ITestResult result, String steps, Section section, TestRail annotation) {
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("custom_test_notes", steps);
            if (this.isAutomatedTestCaseInSection(result.getMethod().getMethodName(), section, annotation)) {
                Object response = this.postRequest("update_case/" + this.tmpTestCase.getId(), data);
                this.setCurrentTestCase(this.toClass(response, TestCase.class));
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }

    public boolean isAutomatedTestCaseInSection(String testName, Section section, TestRail annotation) {
        this.tmpTestCase = null;
        try {
            Object response = this.getRequest("/get_cases/" + this.currentProjectID + "&type_id=" + annotation.testType().value() + "&suite_id=" + this.suiteId + "&section_id=" + section.getId());
            List<TestCase> existingTestCases = this.toCollection(response, TestCase.class);
            for (TestCase tc : existingTestCases) {
                if (!tc.getTitle().equals(testName)) continue;
                this.setCurrentTestCase(tc);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Cannot get test cases from Test Rail. Error %s", e.getMessage()));
        }
        return false;
    }

    public Object updateTestCaseResult(ITestResult result, Run run) {
        Bug bugAnnotated;
        if (this.tmpTestCase == null) {
            return null;
        }
        int status = 2;
        switch (result.getStatus()) {
            case 1: {
                status = 1;
                break;
            }
            case 2: {
                status = 5;
                break;
            }
            case 3: {
                status = 4;
                break;
            }
            case 4: {
                status = 1;
                break;
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("status_id", status);
        if (result.getThrowable() != null && result.getThrowable().getStackTrace() != null) {
            StringWriter sw = new StringWriter();
            result.getThrowable().printStackTrace(new PrintWriter(sw));
            data.put("comment", sw.toString());
        }
        if ((bugAnnotated = result.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Bug.class)) != null) {
            data.put("defects", bugAnnotated.id());
        }
        Object response = "";
        try {
            response = this.postRequest("add_result_for_case/" + run.getId() + "/" + this.tmpTestCase.getId(), data);
        }
        catch (Exception e) {
            LOG.error("Cannot update Test Case status execution. Error: {}, Response: {}", (Object)e.getMessage(), (Object)response.toString());
            return e.getMessage();
        }
        return response;
    }

    public Run getRunOfCurrentProject() {
        Run r = this.getRun(this.currentRun, this.currentProjectID);
        if (r == null) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("suite_id", this.suiteId);
            data.put("name", this.currentRun);
            data.put("include_all", true);
            data.put("description", "**Server:** " + this.serverUrl);
            LOG.info("Add new RUN [{}]", (Object)this.currentRun);
            try {
                Object response = this.postRequest("add_run/" + this.currentProjectID, data);
                r = this.toClass(response, Run.class);
            }
            catch (Exception e) {
                LOG.error("Cannot add new section: {}", (Object)e.getMessage());
            }
        }
        return r;
    }

    public String getFullTestCaseName(ITestResult result) {
        return String.format("%s#%s", result.getInstanceName(), result.getMethod().getMethodName());
    }

    public List<Section> getSections(int projectID) {
        LOG.info("Get all sections from Test Rail Project with id: {}", (Object)projectID);
        try {
            Object response = this.getRequest("get_sections/" + projectID + "&suite_id=" + this.suiteId);
            return this.toCollection(response, Section.class);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new ArrayList<Section>();
        }
    }

    public List<Run> getRuns(int projectID) {
        LOG.info("Get all Runs from Test Rail Project with id: {}", (Object)projectID);
        try {
            Object response = this.getRequest("get_runs/" + projectID);
            return this.toCollection(response, Run.class);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            return new ArrayList<Run>();
        }
    }
}

