/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testrail.core;

import java.util.List;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.report.log.Step;
import org.alfresco.utility.testrail.annotation.TestRail;
import org.alfresco.utility.testrail.core.TestCaseDestination;
import org.alfresco.utility.testrail.model.Section;
import org.alfresco.utility.testrail.model.TestCase;
import org.testng.ITestResult;

public class TestCaseDetail {
    private String id;
    private String name;
    private TestRail annotation = null;
    private Bug bugAnnotated = null;
    private TestCaseDestination testCaseDestination = new TestCaseDestination();
    private TestCase testRailObject = null;
    private ITestResult result;
    private long elapsed;
    private String notes = "";

    public String getNotes() {
        return this.notes;
    }

    public TestCaseDetail(ITestResult currentTest) {
        this.setResult(currentTest);
        Object[] objs = currentTest.getParameters();
        if (objs.length > 0) {
            this.name = objs[0].toString();
            this.id = String.format("%s#%s", currentTest.getInstanceName(), this.name);
        } else {
            this.id = String.format("%s#%s", currentTest.getInstanceName(), currentTest.getMethod().getMethodName());
            this.name = currentTest.getMethod().getMethodName();
        }
        this.annotation = currentTest.getMethod().getConstructorOrMethod().getMethod().getAnnotation(TestRail.class);
        this.bugAnnotated = currentTest.getMethod().getConstructorOrMethod().getMethod().getAnnotation(Bug.class);
        this.testCaseDestination.fromAnnotation(this.annotation);
        this.setElapsed(currentTest.getEndMillis() - currentTest.getStartMillis());
        StringBuilder notesSB = new StringBuilder("");
        if (Step.testSteps.get(this.getResult().getTestClass().getName()) != null) {
            notesSB.append("Dataprep\n========\n* ").append(String.join((CharSequence)"\n* ", (Iterable<? extends CharSequence>)Step.testSteps.get(this.result.getTestClass().getName())));
        }
        if (Step.testSteps.get(this.result.getMethod().getMethodName()) != null) {
            notesSB.append("\n\nTestCase Steps\n=========\n* ").append(String.join((CharSequence)"\n* ", (Iterable<? extends CharSequence>)Step.testSteps.get(this.result.getMethod().getMethodName())));
        }
        this.notes = notesSB.toString();
    }

    public Bug getBugDetails() {
        return this.bugAnnotated;
    }

    public TestCaseDestination getTestCaseDestination() {
        return this.testCaseDestination;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TestRail getTestRailAnnotation() {
        return this.annotation;
    }

    public boolean isMarkForUpload() {
        return this.getTestRailAnnotation() != null;
    }

    public boolean hasSectionCreatedIn(List<Section> allSections) {
        for (Section tmpSection : allSections) {
            if (tmpSection.getDepth() != 0 || !tmpSection.getName().equals(this.getTestCaseDestination().getRootSectionName())) continue;
            this.getTestCaseDestination().setRootSection(tmpSection);
            break;
        }
        if (this.getTestCaseDestination().hasRootSection()) {
            Section parent = this.getTestCaseDestination().getRootSection();
            int depth = 0;
            for (String destinationSection : this.getTestCaseDestination().getChildDestinationSection()) {
                ++depth;
                for (Section s : allSections) {
                    if (!s.getName().equals(destinationSection) || s.getDepth() != depth || s.getParent_id() != parent.getId()) continue;
                    parent = s;
                    if (depth != this.getTestCaseDestination().getChildDestinationSection().size()) continue;
                    this.getTestCaseDestination().setDestination(s);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public TestCase getTestRailObject() {
        return this.testRailObject;
    }

    public void setTestRailObject(TestCase testRailObject) {
        this.testRailObject = testRailObject;
    }

    public int getStatusId() {
        int status = 2;
        switch (this.getResult().getStatus()) {
            case 1: {
                status = 1;
                break;
            }
            case 2: {
                status = 5;
                break;
            }
            case 3: {
                status = 4;
                break;
            }
            case 4: {
                status = 1;
                break;
            }
        }
        return status;
    }

    public ITestResult getResult() {
        return this.result;
    }

    public void setResult(ITestResult result) {
        this.result = result;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long elapsed) {
        this.elapsed = elapsed;
    }

    public String getElapsedString() {
        if (this.getElapsed() <= 1000L) {
            return "1s";
        }
        return String.valueOf(this.elapsed / 1000L) + "s";
    }
}

