/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.renderer;

import org.alfresco.utility.LogFactory;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.exception.PageRenderTimeException;
import org.alfresco.utility.web.annotation.RenderWebElement;
import org.alfresco.utility.web.browser.WebBrowser;
import org.alfresco.utility.web.renderer.Renderer;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.support.FindBy;
import org.slf4j.Logger;

public abstract class RenderElement
implements Renderer {
    Logger LOG = LogFactory.getLogger();
    protected RenderWebElement renderAnnotation;

    protected By buildFromFindBy(FindBy findBy) {
        if (!"".equals(findBy.className())) {
            return By.className((String)findBy.className());
        }
        if (!"".equals(findBy.css())) {
            return By.cssSelector((String)findBy.css());
        }
        if (!"".equals(findBy.id())) {
            return By.id((String)findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            return By.linkText((String)findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            return By.name((String)findBy.name());
        }
        if (!"".equals(findBy.partialLinkText())) {
            return By.partialLinkText((String)findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            return By.tagName((String)findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            return By.xpath((String)findBy.xpath());
        }
        return null;
    }

    @Override
    public void render(RenderWebElement renderAnnotation, FindBy findByAnnotation, WebBrowser browser, TasProperties properties) {
        this.renderAnnotation = renderAnnotation;
        By locator = this.buildFromFindBy(findByAnnotation);
        this.render(locator, browser, properties);
    }

    @Override
    public void render(RenderWebElement renderAnnotation, By locator, WebBrowser browser, TasProperties properties) {
        this.renderAnnotation = renderAnnotation;
        this.render(locator, browser, properties);
    }

    private void render(By locator, WebBrowser browser, TasProperties properties) {
        this.LOG.info("Waiting to render element {} using {} worker", (Object)locator.toString(), (Object)this.getClass().getSimpleName());
        try {
            this.doWork(locator, browser, properties.getExplicitWait());
        }
        catch (NoSuchElementException | TimeoutException e) {
            this.LOG.error("Unable to render the element : " + locator.toString(), e);
            throw new PageRenderTimeException("Element was not rendered in time. Locator: " + locator.toString());
        }
    }

    protected abstract void doWork(By var1, WebBrowser var2, long var3);
}

