/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data;

import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.AndTerm;
import jakarta.mail.search.FlagTerm;
import jakarta.mail.search.SearchTerm;
import java.util.ArrayList;
import java.util.Properties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.TestData;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataEmail
extends TestData<DataEmail> {
    private boolean found = false;
    private Folder folder = null;
    private Store store = null;

    private void connectToHost(UserModel userModel, String host, int port, String protocol) throws Exception {
        Step.STEP(String.format("DATAEMAIL: Connect to IMAP with %s/%s using port %d and host %s", userModel.getUsername(), userModel.getPassword(), port, host));
        Properties props = new Properties();
        props.setProperty("mail.store.protocol", protocol);
        Session session = Session.getDefaultInstance((Properties)props, null);
        this.store = session.getStore(protocol);
        try {
            this.store.connect(host, port, userModel.getUsername(), userModel.getPassword());
        }
        catch (MessagingException authEx) {
            LOG.info("User failed to connect to IMAP Server [{}], port [{}]", (Object)host, (Object)port);
            throw new TestConfigurationException(String.format("User failed to connect to IMAP server %s", authEx.getMessage()));
        }
        this.folder = this.store.getFolder("inbox");
        if (!this.folder.isOpen()) {
            this.folder.open(2);
        }
    }

    private Message[] findMessagesBySubject(final String subject) throws Exception {
        Step.STEP(String.format("DATAEMAIL: Search for messages with subject '%s' in folder '%s'", subject, this.folder.getName()));
        SearchTerm subjectSearchTerm = new SearchTerm(){
            private static final long serialVersionUID = 1L;

            public boolean match(Message message) {
                try {
                    if (message.getSubject().equals(subject)) {
                        return true;
                    }
                }
                catch (MessagingException me) {
                    me.printStackTrace();
                }
                return false;
            }
        };
        FlagTerm unseenFlagTerm = new FlagTerm(new Flags(Flags.Flag.SEEN), false);
        return this.folder.search((SearchTerm)new AndTerm(subjectSearchTerm, (SearchTerm)unseenFlagTerm));
    }

    private void deleteMessages() throws Exception {
        Step.STEP(String.format("DATAEMAIL: Delete all messages from folder %s", this.folder.getName()));
        for (Message message : this.folder.getMessages()) {
            message.setFlag(Flags.Flag.DELETED, true);
        }
        this.folder.close(true);
        this.folder.open(2);
    }

    private void closeResources() throws Exception {
        if (this.folder != null && this.folder.isOpen()) {
            this.folder.close(true);
        }
        if (this.store != null) {
            this.store.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] assertEmailHasBeenReceived(UserModel userModel, String host, int port, String protocol, String subject) throws Exception {
        Message[] messages = null;
        ArrayList<MimeMessage> messageArrayList = new ArrayList<MimeMessage>();
        this.connectToHost(userModel, host, port, protocol);
        try {
            for (int retry = 0; retry < 15; ++retry) {
                messages = this.findMessagesBySubject(subject);
                if (messages.length == 0) {
                    Utility.waitToLoopTime(1, new String[0]);
                    continue;
                }
                this.found = true;
                break;
            }
            Assert.assertTrue((boolean)this.found, (String)String.format("Message with subject '%s' has not been found", subject));
            for (Message message : messages) {
                MimeMessage copyOfMessage = new MimeMessage((MimeMessage)message);
                messageArrayList.add(copyOfMessage);
            }
            Message[] messageArray = messageArrayList.toArray(messages);
            return messageArray;
        }
        finally {
            this.deleteMessages();
            this.closeResources();
        }
    }
}

